/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.heytap.mcssdk.b;
import com.heytap.mcssdk.e.d;
import com.heytap.mcssdk.f.c;
import com.heytap.mcssdk.utils.StatUtil;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.mcssdk.utils.g;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.callback.IGetAppNotificationCallBackService;
import com.heytap.msp.push.callback.INotificationPermissionCallback;
import com.heytap.msp.push.callback.ISetAppNotificationCallBackService;
import com.heytap.msp.push.mode.MessageStat;
import com.heytap.msp.push.statis.StatisticUtils;
import com.mcs.aidl.IMcsSdkService;
import com.mcs.aidl.INotifiPermissionCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PushService
implements b {
    private static final String TAG = PushService.class.getSimpleName();
    private static final int ANDROID_T_SDK_VERSION_CODE = 32;
    private static final int[] OLD_MCS_PACKAGE = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115};
    private static final int[] OLD_MCS_RECEIVE_SDK_ACTION = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115, 115, 100, 107, 46, 97, 99, 116, 105, 111, 110, 46, 82, 69, 67, 69, 73, 86, 69, 95, 83, 68, 75, 95, 77, 69, 83, 83, 65, 71, 69};
    private static final int[] NEW_MCS_PACKAGE = new int[]{99, 111, 109, 46, 104, 101, 121, 116, 97, 112, 46, 109, 99, 115};
    private static String NEW_MCS_RECEIVE_SDK_ACTION = "";
    private static final String NEW_MCS_RECEIVE_SDK_ACTION_Base64 = "Y29tLm1jcy5hY3Rpb24uUkVDRUlWRV9TREtfTUVTU0FHRQ==";
    private static final String TYPE = "type";
    private static final int MCS_SUPPORT_VERSION = 1019;
    private static final String EVENT_ID = "eventID";
    private static final String TASK_ID = "taskID";
    private static final String APP_PACKAGE = "appPackage";
    private static final String EXTRA = "extra";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String MESSAGE_ID = "messageID";
    private static final String GLOBAL_ID = "globalID";
    private static final String SUPPORT_OPEN_PUSH = "supportOpenPush";
    private static final String APP_VERSION_NAME = "versionName";
    private static final String APP_VERSION_CODE = "versionCode";
    private static final String PUSH_SDK_VERSION = "pushSdkVersion";
    public static final String MINI_PROGRAM_PKG = "miniProgramPkg";
    private static final int MAX_HOUR_IN_DAY = 23;
    private static final int MAX_MIN_IN_HOUR = 59;
    private static final int SDK_INT_24 = 24;
    private static final int SYSTEM_UID = 1000;
    private static final int DEFAULT_API_MAX_COUNT = 2;
    private static int sCount = 0;
    private static String sMcsPkgName;
    private static boolean sIsNewMcsPkg;
    private Context mContext;
    private List<c> mProcessors = new ArrayList<c>();
    private List<d> mParsers = new ArrayList<d>();
    private String mAuthCode;
    private String mVerifyCode;
    private String mRegisterID = null;
    private ICallBackResultService mICallBackResultService;
    private ISetAppNotificationCallBackService mISetAppNotificationCallBackService;
    private IGetAppNotificationCallBackService mIGetAppNotificationCallBackService;
    private ConcurrentHashMap<Integer, com.heytap.mcssdk.c.a> mAppLimitMap;
    private boolean needStaticRegister = true;
    private static final String ACTION_NOTIFICATION_ADVANCE = "com.heytap.mcs.action.NOTIFICATION_ADVANCE";
    private static final String KEY_CALLBACK = "result_callback";
    private PermissionCallbackProxy mPermissionCallback = new PermissionCallbackProxy();

    public PushService init(Context context, boolean bl) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.innerInit(context);
        com.heytap.mcssdk.utils.d.f(bl);
        return this;
    }

    public void innerInit(Context object) {
        this.mContext = object.getApplicationContext();
        if (sMcsPkgName == null) {
            if ((object = this.getMcsPackageNameInner((Context)object)) == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
                return;
            }
            sMcsPkgName = object;
            sIsNewMcsPkg = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushService() {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (sCount > 0) {
                throw new RuntimeException("PushService can't create again!");
            }
            ++sCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addParser(new com.heytap.mcssdk.e.b());
            this.addParser(new com.heytap.mcssdk.e.a());
            this.addProcessor(new com.heytap.mcssdk.f.b());
            this.addProcessor(new com.heytap.mcssdk.f.a());
            this.mAppLimitMap = new ConcurrentHashMap();
            return;
        }
    }

    public static PushService getInstance() {
        return a.a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMcsPackageNameInner(Context context) {
        com.heytap.mcssdk.utils.d.b(TAG, "getMcsPackageNameInner -- ");
        String string = null;
        if (Build.VERSION.SDK_INT < 24) return null;
        context = context.getPackageManager();
        try {
            try {
                String string2 = Utils.getString(NEW_MCS_PACKAGE);
                ApplicationInfo applicationInfo = context.getApplicationInfo(string2, 0);
                if (applicationInfo != null) {
                    boolean bl;
                    boolean bl2 = (applicationInfo.flags & 1) == 1;
                    int n = context.getPackageUid("android", 0);
                    int n2 = applicationInfo.uid;
                    int n3 = g.a();
                    boolean bl3 = bl = g.a(n2, n3) == n;
                    if (bl2 || bl) {
                        string = string2;
                    }
                    com.heytap.mcssdk.utils.d.b(TAG, "getMcsPackageNameInner packageUid = " + n2 + ", systemUid = " + n + ", userId = " + n3);
                }
                return string;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                com.heytap.mcssdk.utils.d.e(TAG, "NameNotFoundException in get mcs package name:" + nameNotFoundException.getMessage());
                return string;
            }
            catch (Exception exception) {
                com.heytap.mcssdk.utils.d.e(TAG, "Error in get mcs package name:" + exception.getMessage());
            }
        }
        finally {
            return string;
        }
    }

    public String getMcsPackageName(Context object) {
        if (sMcsPkgName == null) {
            if ((object = this.getMcsPackageNameInner((Context)object)) == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = object;
                sIsNewMcsPkg = true;
            }
        }
        return sMcsPkgName;
    }

    public String getReceiveSdkAction(Context context) {
        if (sMcsPkgName == null) {
            this.getMcsPackageNameInner(context);
        }
        if (sIsNewMcsPkg) {
            if (TextUtils.isEmpty((CharSequence)NEW_MCS_RECEIVE_SDK_ACTION)) {
                NEW_MCS_RECEIVE_SDK_ACTION = new String(com.heytap.mcssdk.a.a.b(NEW_MCS_RECEIVE_SDK_ACTION_Base64));
            }
            return NEW_MCS_RECEIVE_SDK_ACTION;
        }
        return Utils.getString(OLD_MCS_RECEIVE_SDK_ACTION);
    }

    public boolean isSupportPushByClient(Context context) {
        return this.isSupportPushInner(context);
    }

    private boolean isSupportPushInner(Context object) {
        if (this.mContext == null) {
            this.mContext = object.getApplicationContext();
        }
        PushService pushService = this;
        object = pushService.getMcsPackageName(pushService.mContext);
        boolean bl = Utils.isExistPackage(this.mContext, (String)object) && Utils.getVersionCode(this.mContext, (String)object) >= 1019 && Utils.isSupportPush(this.mContext, (String)object, SUPPORT_OPEN_PUSH);
        com.heytap.mcssdk.utils.d.b(TAG, "isSupportPushInner -- ".concat(String.valueOf(bl)));
        return bl;
    }

    @Deprecated
    private static void onAppStart(Context context) {
        MessageStat messageStat = new MessageStat(context.getPackageName(), "app_start", null);
        StatUtil.statisticMessage(context, messageStat);
    }

    private synchronized void addProcessor(c c2) {
        if (c2 != null) {
            this.mProcessors.add(c2);
        }
    }

    private synchronized void addParser(d d2) {
        if (d2 != null) {
            this.mParsers.add(d2);
        }
    }

    public List<d> getParsers() {
        return this.mParsers;
    }

    public List<c> getProcessors() {
        return this.mProcessors;
    }

    private boolean checkContext() {
        return this.mContext != null;
    }

    private boolean checkRegisterID() {
        return this.mRegisterID != null;
    }

    private boolean checkAll() {
        return this.checkContext() && this.checkRegisterID();
    }

    public void setAppKeySecret(String string, String string2) {
        this.mAuthCode = string;
        this.mVerifyCode = string2;
    }

    @Override
    public String getRegisterID() {
        return this.mRegisterID;
    }

    @Override
    public void setRegisterID(String string) {
        this.mRegisterID = string;
    }

    private void startMcsService(int n, JSONObject jSONObject) {
        this.startMcsService(n, "", jSONObject);
    }

    public String getMiniProgramPkgFromJSON(JSONObject jSONObject) {
        String string = "";
        if (jSONObject == null) {
            return string;
        }
        try {
            string = jSONObject.optString(MINI_PROGRAM_PKG);
            return string;
        }
        catch (Exception exception) {
            try {
                com.heytap.mcssdk.utils.d.b("Error happened in getMiniProgramPkgFromJSON() :" + exception.getMessage());
                return string;
            }
            catch (Throwable throwable) {
                return string;
            }
        }
    }

    private void startMcsService(int n, String string, JSONObject jSONObject) {
        if (this.checkCommandLimit(n)) {
            if (this.mICallBackResultService != null) {
                string = this.getMiniProgramPkgFromJSON(jSONObject);
                this.mICallBackResultService.onError(this.getErrorCode(n), "api_call_too_frequently", this.mContext.getPackageName(), string);
            }
            return;
        }
        try {
            string = this.getIntent(n, string, jSONObject);
            this.mContext.startService((Intent)string);
            return;
        }
        catch (Exception exception) {
            com.heytap.mcssdk.utils.d.e("startMcsService--Exception" + exception.getMessage());
            return;
        }
    }

    public void bindMcsService(int n) {
        if (this.checkCommandLimit(n)) {
            if (this.mICallBackResultService != null) {
                this.mICallBackResultService.onError(this.getErrorCode(n), "api_call_too_frequently", this.mContext.getPackageName(), "");
            }
            return;
        }
        final Intent intent = this.getIntent(n, "", null);
        this.mContext.bindService(intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                componentName = new Bundle();
                componentName.putAll(intent.getExtras());
                try {
                    IMcsSdkService.Stub.asInterface(iBinder).process((Bundle)componentName);
                }
                catch (Exception exception) {
                    com.heytap.mcssdk.utils.d.b("bindMcsService exception:".concat(String.valueOf(exception)));
                }
                PushService.this.mContext.unbindService((ServiceConnection)this);
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        }, 1);
    }

    private Intent getIntent(int n, String string, JSONObject jSONObject) {
        Intent intent = new Intent();
        PushService pushService = this;
        intent.setAction(pushService.getReceiveSdkAction(pushService.mContext));
        PushService pushService2 = this;
        intent.setPackage(pushService2.getMcsPackageName(pushService2.mContext));
        intent.putExtra(TYPE, n);
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.putOpt(APP_VERSION_NAME, (Object)Utils.getVersionName(this.mContext, this.mContext.getPackageName()));
            jSONObject2.putOpt(APP_VERSION_CODE, (Object)Utils.getVersionCode(this.mContext, this.mContext.getPackageName()));
            if (jSONObject != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    jSONObject2.putOpt(string2, jSONObject.get(string2));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            intent.putExtra(EXTRA, jSONObject2.toString());
        }
        intent.putExtra("params", string);
        intent.putExtra(APP_PACKAGE, this.mContext.getPackageName());
        intent.putExtra("appKey", this.mAuthCode);
        intent.putExtra("appSecret", this.mVerifyCode);
        intent.putExtra("registerID", this.mRegisterID);
        intent.putExtra("sdkVersion", PushService.getSDKVersionName());
        PushService pushService3 = this;
        intent.putExtra("userIdentifier", pushService3.getUserId(pushService3.mContext));
        return intent;
    }

    private int getUserId(Context context) {
        try {
            return (Integer)Context.class.getMethod("getUserId", new Class[0]).invoke((Object)context, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public ICallBackResultService getPushCallback() {
        return this.mICallBackResultService;
    }

    public void setPushCallback(ICallBackResultService iCallBackResultService) {
        this.mICallBackResultService = iCallBackResultService;
    }

    public IGetAppNotificationCallBackService getPushGetAppNotificationCallBack() {
        return this.mIGetAppNotificationCallBackService;
    }

    public ISetAppNotificationCallBackService getPushSetAppNotificationCallBack() {
        return this.mISetAppNotificationCallBackService;
    }

    @Override
    public void register(Context context, String string, String string2, JSONObject jSONObject, ICallBackResultService iCallBackResultService) {
        if (context == null) {
            if (iCallBackResultService != null) {
                iCallBackResultService.onRegister(-2, null, null, null);
            }
            return;
        }
        if (this.mContext == null) {
            this.mContext = context.getApplicationContext();
        }
        if (!Utils.isSupportPushByClient(this.mContext)) {
            if (iCallBackResultService != null) {
                iCallBackResultService.onRegister(-2, null, null, null);
            }
            return;
        }
        if (this.needStaticRegister) {
            com.heytap.mcssdk.utils.d.b("registerAction:", "Will static push_register event :");
            StatisticUtils.statisticEvent(this.mContext, "push_register");
            this.needStaticRegister = false;
        }
        this.mAuthCode = string;
        this.mVerifyCode = string2;
        this.mICallBackResultService = iCallBackResultService;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        try {
            jSONObject.putOpt("appVersionCode", (Object)Utils.getVersionCode(context));
            jSONObject.putOpt("appVersionName", (Object)Utils.getVersionName(context));
        }
        catch (JSONException jSONException) {
            com.heytap.mcssdk.utils.d.e("register-Exception:" + jSONException.getMessage());
        }
        this.startMcsService(12289, jSONObject);
    }

    @Override
    public void register(Context context, String string, String string2, ICallBackResultService iCallBackResultService) {
        this.register(context, string, string2, null, iCallBackResultService);
    }

    public void unRegister(Context context, String string, String string2, JSONObject jSONObject, ICallBackResultService iCallBackResultService) {
        this.mAuthCode = string;
        this.mVerifyCode = string2;
        this.mContext = context.getApplicationContext();
        this.mICallBackResultService = iCallBackResultService;
        this.unRegister(jSONObject);
    }

    @Override
    public void unRegister(JSONObject object) {
        if (this.checkContext()) {
            this.startMcsService(12290, (JSONObject)object);
            return;
        }
        if (this.getPushCallback() != null) {
            object = this.getMiniProgramPkgFromJSON((JSONObject)object);
            this.getPushCallback().onUnRegister(-2, this.mContext.getPackageName(), (String)object);
        }
    }

    @Override
    public void unRegister() {
        this.unRegister(null);
    }

    @Override
    public void getRegister(JSONObject jSONObject) {
        if (this.checkContext()) {
            this.startMcsService(12289, jSONObject);
            return;
        }
        if (this.getPushCallback() != null) {
            this.getPushCallback().onRegister(-2, null, null, null);
        }
    }

    @Override
    public void getRegister() {
        this.getRegister(null);
    }

    @Override
    public void pausePush(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12299, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    @Override
    public void pausePush() {
        this.pausePush(null);
    }

    @Override
    public void resumePush(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12300, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    @Override
    public void resumePush() {
        this.resumePush(null);
    }

    @Override
    public void getNotificationStatus(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12309, jSONObject);
            return;
        }
        if (this.getPushCallback() != null) {
            this.getPushCallback().onGetNotificationStatus(-2, 0);
        }
    }

    @Override
    public void getNotificationStatus() {
        this.getNotificationStatus(null);
    }

    @Override
    public void setNotificationType(int n, JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12307, String.valueOf(n), jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    @Override
    public void setNotificationType(int n) {
        this.setNotificationType(n, null);
    }

    @Override
    public void clearNotificationType(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12308, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    @Override
    public void clearNotificationType() {
        this.clearNotificationType(null);
    }

    @Override
    public void openNotificationSettings(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12310, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    @Override
    public void openNotificationSettings() {
        this.openNotificationSettings(null);
    }

    @Override
    public void clearNotifications() {
        this.clearNotifications(null);
    }

    @Override
    public void clearNotifications(JSONObject jSONObject) {
        if (this.checkContext()) {
            this.startMcsService(12311, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    public void getPushStatus() {
        if (this.checkAll()) {
            this.startMcsService(12306, null);
            return;
        }
        if (this.getPushCallback() != null) {
            this.getPushCallback().onGetPushStatus(-2, 0);
        }
    }

    public static String getSDKVersionName() {
        return "3.5.3";
    }

    public static int getSDKVersionCode() {
        return 3503;
    }

    public String getPushVersionName() {
        if (this.checkContext()) {
            PushService pushService = this;
            return Utils.getVersionName(this.mContext, pushService.getMcsPackageName(pushService.mContext));
        }
        return "";
    }

    public int getPushVersionCode() {
        if (this.checkContext()) {
            PushService pushService = this;
            return Utils.getVersionCode(this.mContext, pushService.getMcsPackageName(pushService.mContext));
        }
        return 0;
    }

    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4, JSONObject jSONObject) {
        if (this.checkAll()) {
            if (list != null && list.size() > 0 && n >= 0 && n2 >= 0 && n3 >= n && n3 <= 23 && n4 >= n2 && n4 <= 59) {
                try {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("weekDays", (Object)com.heytap.mcssdk.c.b.a(list));
                    jSONObject2.put("startHour", n);
                    jSONObject2.put("startMin", n2);
                    jSONObject2.put("endHour", n3);
                    jSONObject2.put("endMin", n4);
                    this.startMcsService(12298, jSONObject2.toString(), jSONObject);
                    return;
                }
                catch (JSONException jSONException) {
                    com.heytap.mcssdk.utils.d.e("mcssdk---", jSONException.getLocalizedMessage());
                    return;
                }
            }
            throw new IllegalArgumentException("params are not all right,please check params");
        }
        if (this.getPushCallback() != null) {
            this.getPushCallback().onSetPushTime(-2, "please call the register first!");
        }
    }

    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4) {
        this.setPushTime(list, n, n2, n3, n4, null);
    }

    @Override
    public void requestNotificationPermission() {
        if (Build.VERSION.SDK_INT >= 32) {
            com.heytap.mcssdk.utils.d.b(TAG, "requestNotificationPermission() will return due to Android T device , current device Android SDK version code is :" + Build.VERSION.SDK_INT);
            return;
        }
        if (this.checkContext()) {
            this.bindMcsService(12313);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    private boolean checkTop(Activity activity) {
        List list;
        ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
        if (Build.VERSION.SDK_INT >= 21 && (list = activityManager.getAppTasks()) != null && list.size() > 0) {
            list = (ActivityManager.AppTask)list.get(0);
            if (Build.VERSION.SDK_INT >= 23 && list.getTaskInfo().topActivity != null) {
                return activity.getClass().getName().equals(list.getTaskInfo().topActivity.getClassName());
            }
        }
        if ((list = activityManager.getRunningTasks(1)) != null && list.size() > 0) {
            list = (ActivityManager.RunningTaskInfo)list.get(0);
            return activity.getClass().getName().equals(((ActivityManager.RunningTaskInfo)list).topActivity.getClassName());
        }
        return false;
    }

    @Override
    public void requestNotificationAdvance(Activity activity, INotificationPermissionCallback iNotificationPermissionCallback, int n) {
        if (activity == null) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2000, null);
            }
            return;
        }
        if (this.checkCommandLimit(12320)) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2004, null);
            }
            return;
        }
        if (!this.checkTop(activity)) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2001, null);
            }
            return;
        }
        if (0 == activity.checkPermission("android.permission.POST_NOTIFICATIONS", Process.myPid(), Process.myUid())) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2002, null);
            }
            return;
        }
        if (!this.mPermissionCallback.a(iNotificationPermissionCallback)) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2003, null);
            }
            return;
        }
        Intent intent = new Intent();
        intent.setAction(ACTION_NOTIFICATION_ADVANCE);
        intent.setPackage(this.getMcsPackageName((Context)activity));
        Bundle bundle = new Bundle();
        bundle.putBinder(KEY_CALLBACK, (IBinder)this.mPermissionCallback);
        intent.putExtras(bundle);
        PushService pushService = this;
        intent.putExtra("userIdentifier", pushService.getUserId(pushService.mContext));
        try {
            activity.startActivityForResult(intent, n);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            if (iNotificationPermissionCallback != null) {
                iNotificationPermissionCallback.onFail(2005, null);
            }
            return;
        }
    }

    @Override
    public void clearNotificationAdvanceCallback() {
        this.mPermissionCallback.a();
    }

    @Override
    public void enableAppNotificationSwitch(ISetAppNotificationCallBackService iSetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = iSetAppNotificationCallBackService;
            this.startMcsService(12316, null);
            return;
        }
        if (this.mISetAppNotificationCallBackService != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void disableAppNotificationSwitch(ISetAppNotificationCallBackService iSetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = iSetAppNotificationCallBackService;
            this.startMcsService(12317, null);
            return;
        }
        if (this.getPushCallback() != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void getAppNotificationSwitch(IGetAppNotificationCallBackService iGetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mIGetAppNotificationCallBackService = iGetAppNotificationCallBackService;
            this.startMcsService(12318, null);
            return;
        }
        if (this.mIGetAppNotificationCallBackService != null) {
            this.mIGetAppNotificationCallBackService.onGetAppNotificationSwitch(-2, 0);
        }
    }

    @Override
    public void cancelNotification(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12319, jSONObject);
            return;
        }
        com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
    }

    public Context getContext() {
        return this.mContext;
    }

    public Map<Integer, com.heytap.mcssdk.c.a> getAppLimitMap() {
        return this.mAppLimitMap;
    }

    public boolean checkCommandLimit(int n) {
        com.heytap.mcssdk.c.a a2 = this.addCommandToMap(n);
        if (n != 12291 && n != 12312) {
            return a2.b() > 2;
        }
        return false;
    }

    private com.heytap.mcssdk.c.a addCommandToMap(int n) {
        com.heytap.mcssdk.c.a a2;
        if (this.mAppLimitMap.containsKey(n)) {
            a2 = this.mAppLimitMap.get(n);
            if (this.checkTimeNeedUpdate(a2)) {
                a2.a(1);
                a2.a(System.currentTimeMillis());
                com.heytap.mcssdk.utils.d.b("addCommandToMap : appLimitBean.setCount(1)");
            } else {
                com.heytap.mcssdk.c.a a3 = a2;
                a3.a(a3.b() + 1);
                com.heytap.mcssdk.utils.d.b("addCommandToMap :appLimitBean.getCount() + 1");
            }
        } else {
            a2 = new com.heytap.mcssdk.c.a(System.currentTimeMillis(), 1);
            this.mAppLimitMap.put(n, a2);
            com.heytap.mcssdk.utils.d.b("addCommandToMap :appBean is null");
        }
        return a2;
    }

    private boolean checkTimeNeedUpdate(com.heytap.mcssdk.c.a a2) {
        long l = a2.a();
        long l2 = System.currentTimeMillis();
        com.heytap.mcssdk.utils.d.b("checkTimeNeedUpdate : lastedTime " + l + " currentTime:" + l2);
        return l2 - l > 1000L;
    }

    public int getErrorCode(int n) {
        switch (n) {
            case 12289: {
                return -1;
            }
            case 12290: {
                return -2;
            }
            case 12299: {
                return -3;
            }
            case 12300: {
                return -4;
            }
            case 12309: {
                return -5;
            }
            case 12307: {
                return -6;
            }
            case 12308: {
                return -7;
            }
            case 12310: {
                return -8;
            }
            case 12311: {
                return -9;
            }
            case 12306: {
                return -10;
            }
            case 12298: {
                return -11;
            }
            case 12313: {
                return -12;
            }
            case 12312: {
                return -13;
            }
            case 12291: {
                return -14;
            }
            case 12316: {
                return -15;
            }
            case 12317: {
                return -16;
            }
            case 12318: {
                return -17;
            }
        }
        return 0;
    }

    private static class a {
        private static final PushService a = new PushService();

        private a() {
        }
    }

    public static final class PermissionCallbackProxy
    extends INotifiPermissionCallback.Stub {
        private static final long a = 2000L;
        private INotificationPermissionCallback b;
        private long c = 0L;

        private boolean b() {
            return SystemClock.elapsedRealtime() - this.c <= 2000L;
        }

        private void c() {
            this.c = SystemClock.elapsedRealtime();
        }

        private void d() {
            this.c = 0L;
        }

        public final boolean a(INotificationPermissionCallback iNotificationPermissionCallback) {
            if (this.b()) {
                return false;
            }
            this.c();
            this.b = iNotificationPermissionCallback;
            return true;
        }

        @Override
        public final void onSuccess() {
            this.d();
            if (this.b != null) {
                this.b.onSuccess();
            }
            this.b = null;
        }

        @Override
        public final void onFail(int n, String string) {
            this.d();
            if (this.b != null) {
                this.b.onFail(n, string);
            }
            this.b = null;
        }

        public final void a() {
            this.d();
            this.b = null;
        }
    }
}

