/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.Intent;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.mcssdk.utils.d;
import com.heytap.msp.push.mode.MessageStat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StatUtil {
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String STAT_LIST = "list";
    private static final int MCS_SUPPORT_VERSION = 1017;

    public static void statisticMessage(Context context, MessageStat messageStat) {
        LinkedList<MessageStat> linkedList = new LinkedList<MessageStat>();
        linkedList.add(messageStat);
        StatUtil.statisticMessage(context, linkedList);
    }

    public static boolean statisticMessage(Context context, List<MessageStat> list) {
        LinkedList<MessageStat> linkedList = new LinkedList<MessageStat>();
        linkedList.addAll(list);
        d.b("isSupportStatisticByMcs:" + StatUtil.isSupportStatisticByMcs(context) + ",list size:" + linkedList.size());
        if (linkedList.size() > 0 && StatUtil.isSupportStatisticByMcs(context)) {
            return StatUtil.statisticMessageByMcs(context, linkedList);
        }
        return false;
    }

    private static boolean isSupportStatisticByMcs(Context context) {
        String string2 = PushService.getInstance().getMcsPackageName(context);
        return Utils.isExistPackage(context, string2) && Utils.getVersionCode(context, string2) >= 1017;
    }

    private static boolean statisticMessageByMcs(Context context, List<MessageStat> object) {
        try {
            Intent intent = new Intent();
            intent.setAction(PushService.getInstance().getReceiveSdkAction(context));
            intent.setPackage(PushService.getInstance().getMcsPackageName(context));
            intent.putExtra("appPackage", context.getPackageName());
            intent.putExtra(TYPE, 12291);
            intent.putExtra(COUNT, object.size());
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                MessageStat messageStat = (MessageStat)object.next();
                arrayList.add(messageStat.toJsonObject());
            }
            intent.putStringArrayListExtra(STAT_LIST, arrayList);
            context.startService(intent);
            return true;
        }
        catch (Exception exception) {
            d.e("statisticMessage--Exception" + exception.getMessage());
            return false;
        }
    }
}

