/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.assist.control.oppo;

import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.igexin.assist.MessageBean;
import com.igexin.assist.action.MessageManger;
import com.igexin.assist.control.AbstractPushManager;
import com.igexin.assist.control.oppo.Utils;
import java.util.ArrayList;

public class ManufacturePushManager
implements ICallBackResultService,
AbstractPushManager {
    public static final String TAG = "Assist_OP";
    public static final String PLUGIN_VERSION = "3.4.0";
    private Context context;
    private String appKey = "";
    private String appSecret = "";

    public ManufacturePushManager(Context context) {
        try {
            this.context = context;
            Log.d((String)TAG, (String)("oppo plugin version = 3.4.0, oppo sdk version = " + HeytapPushManager.getSDKVersionName()));
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            this.appKey = Utils.getAppKeyByBuildConfig(applicationInfo);
            if (TextUtils.isEmpty((CharSequence)this.appKey)) {
                this.appKey = (String)applicationInfo.metaData.get("OPPOPUSH_APPKEY");
                this.appKey = this.appKey.replace("OP_", "");
            }
            this.appSecret = Utils.getAppSecretByBuildConfig(applicationInfo);
            if (TextUtils.isEmpty((CharSequence)this.appSecret)) {
                this.appSecret = (String)applicationInfo.metaData.get("OPPOPUSH_APPSECRET");
                this.appSecret = this.appSecret.replace("OP_", "");
            }
            this.createNotificationChannel(context);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    private void createNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT < 26 || !this.isSupport()) {
            return;
        }
        context = (NotificationManager)context.getSystemService("notification");
        Class<?> clazz = Class.forName("android.app.NotificationChannel");
        Parcelable parcelable = clazz.getConstructor(String.class, CharSequence.class, Integer.TYPE);
        if (parcelable != null) {
            Class<NotificationManager> clazz2 = NotificationManager.class;
            if ((Parcelable)NotificationManager.class.getMethod("getNotificationChannel", String.class).invoke((Object)context, "Default") == null) {
                parcelable = (Parcelable)parcelable.newInstance("Default", "Default", 3);
                clazz2.getMethod("createNotificationChannel", clazz).invoke((Object)context, parcelable);
            }
        }
    }

    public void register(Context context) {
        try {
            this.context = context;
            if (TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)this.appSecret)) {
                Log.d((String)TAG, (String)"Register oppo push appKey or appSecret is null or empty");
                return;
            }
            Log.d((String)TAG, (String)("Register oppo push, pkg = " + context.getPackageName() + ", appKey = " + this.appKey + ", appSecret = " + this.appSecret));
            if (this.isSupport()) {
                HeytapPushManager.register(context, this.appKey, this.appSecret, this);
                return;
            }
            Log.d((String)TAG, (String)"not support oppo push.");
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void unregister(Context context) {
        try {
            HeytapPushManager.unRegister();
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void turnOnPush(Context context) {
        try {
            HeytapPushManager.resumePush();
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void turnOffPush(Context context) {
        try {
            HeytapPushManager.pausePush();
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public String getToken(Context context) {
        return HeytapPushManager.getRegisterID();
    }

    public void setSilentTime(Context context, int n, int n2) {
        if (n2 == 0) {
            this.turnOnPush(context);
            return;
        }
        int n3 = (n + n2) % 24;
        Log.d((String)TAG, (String)("getui setSilentTime" + n + ":" + n2));
        Log.d((String)TAG, (String)("oppo push setAcceptTime" + n3 + ":" + n));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            arrayList.add(i);
        }
        HeytapPushManager.setPushTime(arrayList, n3, 0, n, 0);
    }

    public boolean isSupport() {
        if (this.context == null) {
            return false;
        }
        try {
            HeytapPushManager.init(this.context, false);
            boolean bl = HeytapPushManager.isSupportPush(this.context);
            Log.d((String)TAG, (String)"is oppo:".concat(String.valueOf(bl)));
            return bl;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return false;
        }
    }

    public static boolean checkOppoDevice(Context context) {
        try {
            HeytapPushManager.init(context, false);
            return HeytapPushManager.isSupportPush(context);
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return false;
        }
    }

    public String getBrandCode() {
        return "4";
    }

    @Override
    public void onRegister(int n, String string2, String stringArray, String string3) {
        try {
            Log.d((String)TAG, (String)("onToken :" + string2 + ", code = " + n));
            if (this.context != null && n == 0 && !TextUtils.isEmpty((CharSequence)string2) && !string2.equalsIgnoreCase("InvalidAppKey")) {
                String string4 = "";
                stringArray = string2.split("_");
                if (stringArray.length == 1) {
                    string4 = "OP_".concat(String.valueOf(string2));
                } else if (stringArray.length == 2) {
                    string4 = stringArray[0].equalsIgnoreCase("CN") ? "OP_".concat(String.valueOf(string2)) : "OPG_".concat(String.valueOf(string2));
                } else if (stringArray.length == 3) {
                    string4 = stringArray[1].equalsIgnoreCase("CN") ? "OP_".concat(String.valueOf(string2)) : "OPG_".concat(String.valueOf(string2));
                }
                string4 = new MessageBean(this.context, "token", (Object)string4);
                MessageManger.getInstance().addMessage((MessageBean)string4);
            }
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    @Override
    public void onUnRegister(int n, String string2, String string3) {
    }

    @Override
    public void onGetPushStatus(int n, int n2) {
    }

    @Override
    public void onSetPushTime(int n, String string2) {
    }

    @Override
    public void onGetNotificationStatus(int n, int n2) {
    }

    @Override
    public void onError(int n, String string2, String string3, String string4) {
    }
}

