/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.components;

public class RetryManager {
    private static final int MAX_TAP_TO_RETRY_ATTEMPTS = 4;
    private boolean mTapToRetryEnabled;
    private int mMaxTapToRetryAttempts;
    private int mTapToRetryAttempts;

    public RetryManager() {
        this.init();
    }

    public static RetryManager newInstance() {
        return new RetryManager();
    }

    public void init() {
        this.mTapToRetryEnabled = false;
        this.mMaxTapToRetryAttempts = 4;
        this.reset();
    }

    public void reset() {
        this.mTapToRetryAttempts = 0;
    }

    public boolean isTapToRetryEnabled() {
        return this.mTapToRetryEnabled;
    }

    public void setTapToRetryEnabled(boolean tapToRetryEnabled) {
        this.mTapToRetryEnabled = tapToRetryEnabled;
    }

    public boolean shouldRetryOnTap() {
        return this.mTapToRetryEnabled && this.mTapToRetryAttempts < this.mMaxTapToRetryAttempts;
    }

    public void notifyTapToRetry() {
        ++this.mTapToRetryAttempts;
    }
}

