/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.generic;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.facebook.drawee.R;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import javax.annotation.Nullable;

public class GenericDraweeHierarchyInflater {
    public static GenericDraweeHierarchy inflateHierarchy(Context context, @Nullable AttributeSet attrs) {
        return GenericDraweeHierarchyInflater.inflateBuilder(context, attrs).build();
    }

    public static GenericDraweeHierarchyBuilder inflateBuilder(Context context, @Nullable AttributeSet attrs) {
        Resources resources = context.getResources();
        GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(resources);
        return GenericDraweeHierarchyInflater.updateBuilder(builder, context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericDraweeHierarchyBuilder updateBuilder(GenericDraweeHierarchyBuilder builder, Context context, @Nullable AttributeSet attrs) {
        int progressBarAutoRotateInterval = 0;
        int roundedCornerRadius = 0;
        boolean roundTopLeft = true;
        boolean roundTopRight = true;
        boolean roundBottomLeft = true;
        boolean roundBottomRight = true;
        if (attrs != null) {
            TypedArray gdhAttrs = context.obtainStyledAttributes(attrs, R.styleable.GenericDraweeHierarchy);
            try {
                int indexCount = gdhAttrs.getIndexCount();
                for (int i = 0; i < indexCount; ++i) {
                    int attr = gdhAttrs.getIndex(i);
                    if (attr == R.styleable.GenericDraweeHierarchy_actualImageScaleType) {
                        builder.setActualImageScaleType(GenericDraweeHierarchyInflater.getScaleTypeFromXml(gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_placeholderImage) {
                        builder.setPlaceholderImage(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_pressedStateOverlayImage) {
                        builder.setPressedStateOverlay(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_progressBarImage) {
                        builder.setProgressBarImage(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_fadeDuration) {
                        builder.setFadeDuration(gdhAttrs.getInt(attr, 0));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_viewAspectRatio) {
                        builder.setDesiredAspectRatio(gdhAttrs.getFloat(attr, 0.0f));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_placeholderImageScaleType) {
                        builder.setPlaceholderImageScaleType(GenericDraweeHierarchyInflater.getScaleTypeFromXml(gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_retryImage) {
                        builder.setRetryImage(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_retryImageScaleType) {
                        builder.setRetryImageScaleType(GenericDraweeHierarchyInflater.getScaleTypeFromXml(gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_failureImage) {
                        builder.setFailureImage(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_failureImageScaleType) {
                        builder.setFailureImageScaleType(GenericDraweeHierarchyInflater.getScaleTypeFromXml(gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_progressBarImageScaleType) {
                        builder.setProgressBarImageScaleType(GenericDraweeHierarchyInflater.getScaleTypeFromXml(gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_progressBarAutoRotateInterval) {
                        progressBarAutoRotateInterval = gdhAttrs.getInteger(attr, progressBarAutoRotateInterval);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_backgroundImage) {
                        builder.setBackground(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_overlayImage) {
                        builder.setOverlay(GenericDraweeHierarchyInflater.getDrawable(context, gdhAttrs, attr));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundAsCircle) {
                        GenericDraweeHierarchyInflater.getRoundingParams(builder).setRoundAsCircle(gdhAttrs.getBoolean(attr, false));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundedCornerRadius) {
                        roundedCornerRadius = gdhAttrs.getDimensionPixelSize(attr, roundedCornerRadius);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundTopLeft) {
                        roundTopLeft = gdhAttrs.getBoolean(attr, roundTopLeft);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundTopRight) {
                        roundTopRight = gdhAttrs.getBoolean(attr, roundTopRight);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundBottomLeft) {
                        roundBottomLeft = gdhAttrs.getBoolean(attr, roundBottomLeft);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundBottomRight) {
                        roundBottomRight = gdhAttrs.getBoolean(attr, roundBottomRight);
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundWithOverlayColor) {
                        GenericDraweeHierarchyInflater.getRoundingParams(builder).setOverlayColor(gdhAttrs.getColor(attr, 0));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundingBorderWidth) {
                        GenericDraweeHierarchyInflater.getRoundingParams(builder).setBorderWidth(gdhAttrs.getDimensionPixelSize(attr, 0));
                        continue;
                    }
                    if (attr == R.styleable.GenericDraweeHierarchy_roundingBorderColor) {
                        GenericDraweeHierarchyInflater.getRoundingParams(builder).setBorderColor(gdhAttrs.getColor(attr, 0));
                        continue;
                    }
                    if (attr != R.styleable.GenericDraweeHierarchy_roundingBorderPadding) continue;
                    GenericDraweeHierarchyInflater.getRoundingParams(builder).setPadding(gdhAttrs.getDimensionPixelSize(attr, 0));
                }
            }
            finally {
                gdhAttrs.recycle();
            }
        }
        if (builder.getProgressBarImage() != null && progressBarAutoRotateInterval > 0) {
            builder.setProgressBarImage(new AutoRotateDrawable(builder.getProgressBarImage(), progressBarAutoRotateInterval));
        }
        if (roundedCornerRadius > 0) {
            GenericDraweeHierarchyInflater.getRoundingParams(builder).setCornersRadii(roundTopLeft ? (float)roundedCornerRadius : 0.0f, roundTopRight ? (float)roundedCornerRadius : 0.0f, roundBottomRight ? (float)roundedCornerRadius : 0.0f, roundBottomLeft ? (float)roundedCornerRadius : 0.0f);
        }
        return builder;
    }

    private static RoundingParams getRoundingParams(GenericDraweeHierarchyBuilder builder) {
        if (builder.getRoundingParams() == null) {
            builder.setRoundingParams(new RoundingParams());
        }
        return builder.getRoundingParams();
    }

    @Nullable
    private static Drawable getDrawable(Context context, TypedArray gdhAttrs, int attrId) {
        int resourceId = gdhAttrs.getResourceId(attrId, 0);
        return resourceId == 0 ? null : context.getResources().getDrawable(resourceId);
    }

    @Nullable
    private static ScalingUtils.ScaleType getScaleTypeFromXml(TypedArray gdhAttrs, int attrId) {
        switch (gdhAttrs.getInt(attrId, -2)) {
            case -1: {
                return null;
            }
            case 0: {
                return ScalingUtils.ScaleType.FIT_XY;
            }
            case 1: {
                return ScalingUtils.ScaleType.FIT_START;
            }
            case 2: {
                return ScalingUtils.ScaleType.FIT_CENTER;
            }
            case 3: {
                return ScalingUtils.ScaleType.FIT_END;
            }
            case 4: {
                return ScalingUtils.ScaleType.CENTER;
            }
            case 5: {
                return ScalingUtils.ScaleType.CENTER_INSIDE;
            }
            case 6: {
                return ScalingUtils.ScaleType.CENTER_CROP;
            }
            case 7: {
                return ScalingUtils.ScaleType.FOCUS_CROP;
            }
        }
        throw new RuntimeException("XML attribute not specified!");
    }
}

