/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import com.getui.gtc.base.crypt.SecureCryptTools;
import com.getui.gtc.base.publish.Broker;
import com.getui.gtc.base.publish.Publisher;
import com.getui.gtc.base.util.CommonUtil;
import com.getui.gtc.base.util.EmptyProvider;
import com.getui.gtc.base.util.OnForegroundChangedListener;
import com.getui.gtc.base.util.ScheduleQueue;
import java.util.Collections;
import java.util.Set;

public class GtcProvider
extends EmptyProvider
implements Publisher {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static int gtcPid;
    private static String sdcardPath;
    private static boolean isCheckedLifecycle;
    private static boolean lazyInitCrypt;
    private static volatile boolean isForeground;
    private static final String METHOD_ON_FOREGROUND_CHANGED = "onForegroundChanged";

    public static void setContext(Context context) {
        if (GtcProvider.context == null && context != null) {
            GtcProvider.context = context.getApplicationContext();
        }
        GtcProvider.tryListenerForeground(GtcProvider.context);
    }

    public static Context context() {
        return context;
    }

    public static void lazyInitCrypt() {
        lazyInitCrypt = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryListenerForeground(final Context context) {
        try {
            if (isCheckedLifecycle) {
                return;
            }
            Class<GtcProvider> clazz = GtcProvider.class;
            synchronized (GtcProvider.class) {
                if (isCheckedLifecycle) {
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
                if ((context = context != null ? context.getApplicationContext() : CommonUtil.findAppContext()) == null) {
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
                if (CommonUtil.isMainProcess(context)) {
                    ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new OnForegroundChangedListener(){

                        @Override
                        public final void onForegroundChanged(boolean bl) {
                            isForeground = bl;
                            if (Process.myPid() != gtcPid) {
                                GtcProvider.subscribe(context, bl);
                            }
                        }
                    });
                    if (Process.myPid() != gtcPid && CommonUtil.getTopActivity() != null) {
                        isForeground = true;
                        GtcProvider.subscribe(context, true);
                    }
                }
                isCheckedLifecycle = true;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private static void subscribe(final Context context, final boolean bl) {
        ScheduleQueue.getInstance().addSchedule(new Runnable(){

            @Override
            public final void run() {
                Uri uri = Uri.parse((String)("content://" + context.getPackageName() + ".getui.gtc.provider"));
                context.getContentResolver().call(uri, GtcProvider.METHOD_ON_FOREGROUND_CHANGED, Boolean.toString(bl), null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getSdcardPath() {
        if (sdcardPath != null) return sdcardPath;
        Class<GtcProvider> clazz = GtcProvider.class;
        synchronized (GtcProvider.class) {
            if (sdcardPath != null) return sdcardPath;
            sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sdcardPath;
        }
    }

    public static boolean isForeground() {
        return isForeground;
    }

    @Deprecated
    public static Set<String> getForeActivities() {
        return Collections.emptySet();
    }

    @Deprecated
    public static int mainPid() {
        return gtcPid;
    }

    public static int gtcPid() {
        return gtcPid;
    }

    @Override
    public boolean onCreate() {
        try {
            gtcPid = Process.myPid();
            GtcProvider.setContext(this.getContext());
            if (!lazyInitCrypt) {
                ScheduleQueue.getInstance().addSchedule(new Runnable(){

                    @Override
                    public final void run() {
                        SecureCryptTools.getInstance();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public Bundle call(String string, String string2, Bundle bundle) {
        if (METHOD_ON_FOREGROUND_CHANGED.equals(string)) {
            isForeground = Boolean.parseBoolean(string2);
            return null;
        }
        if (bundle != null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
        }
        return this.publish(bundle);
    }

    @Override
    public Bundle publish(Bundle bundle) {
        return Broker.getInstance().publish(bundle);
    }

    static {
        isCheckedLifecycle = false;
        lazyInitCrypt = false;
        isForeground = false;
    }
}

