/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.Call;
import com.getui.gtc.base.http.Dispatcher;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.RealCall;
import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class GtHttpClient {
    private final Dispatcher dispatcher;
    final List<Interceptor> interceptors;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final boolean followRedirects;
    private final boolean retryOnConnectionFailure;
    private final boolean useCache;
    private final int connectTimeout;
    private final int readTimeout;

    public GtHttpClient() {
        this(new Builder());
    }

    GtHttpClient(Builder builder) {
        this.dispatcher = builder.dispatcher;
        this.interceptors = Util.immutableList(builder.interceptors);
        this.sslSocketFactory = builder.sslSocketFactory;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.followRedirects = builder.followRedirects;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.useCache = builder.useCache;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        if (this.interceptors.contains(null)) {
            throw new IllegalStateException("Null interceptor: " + this.interceptors);
        }
    }

    @Deprecated
    public static GtHttpClient getDefaultInstance() {
        return new Builder().build();
    }

    public Call newCall(Request request) {
        return RealCall.newCall(this, request);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public static final class Builder {
        Dispatcher dispatcher;
        final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        SSLSocketFactory sslSocketFactory;
        HostnameVerifier hostnameVerifier;
        boolean followRedirects;
        boolean retryOnConnectionFailure;
        boolean useCache;
        int connectTimeout;
        int readTimeout;

        public Builder() {
            this.dispatcher = new Dispatcher();
            this.followRedirects = true;
            this.retryOnConnectionFailure = true;
            this.useCache = false;
            this.connectTimeout = 7000;
            this.readTimeout = 7000;
        }

        Builder(GtHttpClient gtHttpClient) {
            this.dispatcher = gtHttpClient.dispatcher;
            this.interceptors.addAll(gtHttpClient.interceptors);
            this.sslSocketFactory = gtHttpClient.sslSocketFactory;
            this.hostnameVerifier = gtHttpClient.hostnameVerifier;
            this.followRedirects = gtHttpClient.followRedirects;
            this.retryOnConnectionFailure = gtHttpClient.retryOnConnectionFailure;
            this.useCache = gtHttpClient.useCache;
            this.connectTimeout = gtHttpClient.connectTimeout;
            this.readTimeout = gtHttpClient.readTimeout;
        }

        public final Builder connectTimeout(long l2, TimeUnit timeUnit) {
            this.connectTimeout = Util.checkDuration("connectTimeout", l2, timeUnit);
            return this;
        }

        public final Builder readTimeout(long l2, TimeUnit timeUnit) {
            this.readTimeout = Util.checkDuration("readTimeout", l2, timeUnit);
            return this;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            if (sSLSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory == null");
            }
            this.sslSocketFactory = sSLSocketFactory;
            return this;
        }

        public final Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new NullPointerException("hostnameVerifier == null");
            }
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public final Builder followRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        public final Builder retryOnConnectionFailure(boolean bl) {
            this.retryOnConnectionFailure = bl;
            return this;
        }

        public final Builder useCache(boolean bl) {
            this.useCache = bl;
            return this;
        }

        public final Builder dispatcher(Dispatcher dispatcher) {
            if (dispatcher == null) {
                throw new IllegalArgumentException("dispatcher == null");
            }
            this.dispatcher = dispatcher;
            return this;
        }

        public final Builder addInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("interceptor == null");
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public final GtHttpClient build() {
            return new GtHttpClient(this);
        }
    }
}

