/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.BridgeInterceptor;
import com.getui.gtc.base.http.Call;
import com.getui.gtc.base.http.CallServerInterceptor;
import com.getui.gtc.base.http.ConnectInterceptor;
import com.getui.gtc.base.http.GtHttpClient;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.RealInterceptorChain;
import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.Response;
import java.io.IOException;
import java.util.ArrayList;

public class RealCall
implements Call {
    private Request request;
    private GtHttpClient client;
    private boolean executed;
    private volatile boolean canceled;

    private RealCall(GtHttpClient gtHttpClient, Request request) {
        this.client = gtHttpClient;
        this.request = request;
    }

    static RealCall newCall(GtHttpClient gtHttpClient, Request request) {
        return new RealCall(gtHttpClient, request);
    }

    @Override
    public Request request() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws Exception {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.getDispatcher().executed(this);
            object = this.getResponseWithInterceptorChain();
            if (object == null) {
                throw new IOException("Canceled");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.client.getDispatcher().finished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Call.Callback callback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.getDispatcher().enqueue(new AsyncCall(callback));
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    Response getResponseWithInterceptorChain() throws Exception {
        ArrayList<Interceptor> arrayList = new ArrayList<Interceptor>();
        arrayList.addAll(this.client.interceptors);
        if (this.request.cryptInterceptor() != null) {
            arrayList.add(this.request.cryptInterceptor());
        }
        arrayList.add(new BridgeInterceptor());
        arrayList.add(new ConnectInterceptor(this.client));
        arrayList.add(new CallServerInterceptor());
        return new RealInterceptorChain(arrayList, null, 0, this.request).proceed(this.request);
    }

    final class AsyncCall
    implements Runnable {
        private final Call.Callback callback;

        AsyncCall(Call.Callback callback) {
            this.callback = callback;
        }

        final RealCall get() {
            return RealCall.this;
        }

        @Override
        public final void run() {
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                if (RealCall.this.isCanceled()) {
                    throw new IOException("Canceled");
                }
                this.callback.onResponse(this.get(), response);
                return;
            }
            catch (Throwable throwable) {
                this.callback.onFailure(this.get(), new Exception(throwable.getMessage(), throwable.getCause()));
                return;
            }
            finally {
                RealCall.this.client.getDispatcher().finished(this);
            }
        }
    }
}

