/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.MediaType;
import com.getui.gtc.base.http.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class RequestBody {
    public abstract MediaType contentType();

    public abstract long contentLength();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public static RequestBody create(MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = ((String)object).getBytes(charset);
        return RequestBody.create(mediaType, (byte[])object);
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final MediaType mediaType, final byte[] byArray, final int n2, final int n3) {
        if (byArray == null) {
            throw new NullPointerException("content == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        return new RequestBody(){

            @Override
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return n3;
            }

            @Override
            public final void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(byArray, n2, n3);
            }
        };
    }

    public static RequestBody create(final MediaType mediaType, final File file) {
        if (file == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            @Override
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return file.length();
            }

            @Override
            public final void writeTo(OutputStream outputStream) throws IOException {
                FileInputStream fileInputStream = null;
                try {
                    int n2;
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[1024];
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n2);
                    }
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(fileInputStream);
                    throw throwable;
                }
                Util.closeQuietly(fileInputStream);
            }
        };
    }
}

