/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.util;

import android.util.Log;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduleQueue {
    private static final String TAG = "ScheduleQueue";
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            runnable = new Thread(runnable);
            ((Thread)runnable).setName("Gtc-ScheduleQueue-" + poolNumber.getAndIncrement());
            ((Thread)runnable).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    Log.e((String)"gtc", (String)("caught an exception from " + thread.getName()), (Throwable)throwable);
                }
            });
            return runnable;
        }
    });

    private ScheduleQueue() {
    }

    public static ScheduleQueue getInstance() {
        return SingletonHolder.instance;
    }

    public boolean addSchedule(Runnable runnable) {
        try {
            this.exec.execute(runnable);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean addSchedule(Runnable runnable, long l2) {
        try {
            this.exec.schedule(runnable, l2, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean addSchedule(Runnable runnable, long l2, long l3) {
        try {
            this.exec.scheduleAtFixedRate(runnable, l2, l3, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public ScheduledFuture<?> addScheduler(Runnable runnable, long l2, long l3) {
        try {
            return this.exec.scheduleAtFixedRate(runnable, l2, l3, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void shutDown() {
        this.exec.shutdown();
    }

    static class SingletonHolder {
        private static final ScheduleQueue instance = new ScheduleQueue();

        private SingletonHolder() {
        }
    }
}

