/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.crypt;

import android.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptTools {
    public static SecretKey parseSecretKey(String string, String object) {
        object = Base64.decode((String)object, (int)0);
        return CryptTools.wrapperKey(string, (byte[])object);
    }

    public static PublicKey parsePublicKey(String object, String object2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object2 = Base64.decode((String)object2, (int)0);
        object = KeyFactory.getInstance((String)object);
        object2 = new X509EncodedKeySpec((byte[])object2);
        return ((KeyFactory)object).generatePublic((KeySpec)object2);
    }

    public static PublicKey parsePublicKey(String object, File object2) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object2)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)object2).charAt(0) == '-') continue;
                stringBuilder.append((String)object2);
                stringBuilder.append('\r');
            }
            object = CryptTools.parsePublicKey((String)object, stringBuilder.toString());
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw throwable;
        }
        bufferedReader.close();
        return object;
    }

    public static PrivateKey parsePrivateKey(String string, String object) throws NoSuchAlgorithmException, InvalidKeySpecException {
        object = Base64.decode((String)object, (int)0);
        object = new PKCS8EncodedKeySpec((byte[])object);
        return KeyFactory.getInstance(string).generatePrivate((KeySpec)object);
    }

    public static PrivateKey parsePrivateKey(String object, File object2) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object2)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)object2).charAt(0) == '-') continue;
                stringBuilder.append((String)object2);
                stringBuilder.append('\r');
            }
            object = CryptTools.parsePrivateKey((String)object, stringBuilder.toString());
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw throwable;
        }
        bufferedReader.close();
        return object;
    }

    public static SecretKey wrapperKey(String string, byte[] byArray) {
        return new SecretKeySpec(byArray, string);
    }

    public static String keyToString(Key object) {
        byte[] byArray = object.getEncoded();
        object = byArray;
        if (byArray == null) {
            throw new RuntimeException("can not transform key to string");
        }
        return Base64.encodeToString((byte[])object, (int)0);
    }

    public static SecretKey generateKey(String object, int n2) throws NoSuchAlgorithmException {
        object = KeyGenerator.getInstance((String)object);
        ((KeyGenerator)object).init(n2);
        return ((KeyGenerator)object).generateKey();
    }

    public static KeyPair generateKeyPair(String object, int n2) throws NoSuchAlgorithmException {
        object = KeyPairGenerator.getInstance((String)object);
        ((KeyPairGenerator)object).initialize(n2);
        return ((KeyPairGenerator)object).generateKeyPair();
    }

    public static byte[] encrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, byte[] byArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(1, (Key)secretKey, ivParameterSpec);
        return ((Cipher)object).doFinal(byArray);
    }

    public static InputStream encrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, InputStream inputStream) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(1, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(inputStream, (Cipher)object);
    }

    public static OutputStream encrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, OutputStream outputStream) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(1, (Key)secretKey, ivParameterSpec);
        return new CipherOutputStream(outputStream, (Cipher)object);
    }

    public static byte[] decrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, byte[] byArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
        return ((Cipher)object).doFinal(byArray);
    }

    public static InputStream decrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, InputStream inputStream) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(inputStream, (Cipher)object);
    }

    public static OutputStream decrypt(String object, SecretKey secretKey, IvParameterSpec ivParameterSpec, OutputStream outputStream) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
        return new CipherOutputStream(outputStream, (Cipher)object);
    }

    public static byte[] encrypt(String object, PublicKey publicKey, byte[] byArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(1, publicKey);
        return ((Cipher)object).doFinal(byArray);
    }

    public static byte[] decrypt(String object, PrivateKey privateKey, byte[] byArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        object = Cipher.getInstance((String)object);
        ((Cipher)object).init(2, privateKey);
        return ((Cipher)object).doFinal(byArray);
    }

    public static byte[] sign(String object, PrivateKey privateKey, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        object = Signature.getInstance((String)object);
        ((Signature)object).initSign(privateKey);
        ((Signature)object).update(byArray);
        return ((Signature)object).sign();
    }

    public static boolean verify(String object, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        object = Signature.getInstance((String)object);
        ((Signature)object).initVerify(publicKey);
        ((Signature)object).update(byArray);
        return ((Signature)object).verify(byArray2);
    }

    public static byte[] digest(String object, byte[] byArray) throws NoSuchAlgorithmException {
        object = MessageDigest.getInstance((String)object);
        ((MessageDigest)object).update(byArray);
        return ((MessageDigest)object).digest();
    }

    public static String digestToHexString(String object, byte[] object2) throws NoSuchAlgorithmException {
        object = CryptTools.digest((String)object, (byte[])object2);
        object2 = new StringBuilder();
        for (reference var4_4 : object) {
            if (var4_4 < 0) {
                var4_4 += 256;
            }
            if (var4_4 < 16) {
                ((StringBuilder)object2).append("0");
            }
            ((StringBuilder)object2).append(Integer.toHexString((int)var4_4));
        }
        return ((StringBuilder)object2).toString();
    }
}

