/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.BufferedSink;
import com.getui.gtc.base.http.Headers;
import com.getui.gtc.base.http.MediaType;
import com.getui.gtc.base.http.RequestBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public final class MultipartBody
extends RequestBody {
    public static final MediaType MIXED = MediaType.get("multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.get("multipart/alternative");
    public static final MediaType DIGEST = MediaType.get("multipart/digest");
    public static final MediaType PARALLEL = MediaType.get("multipart/parallel");
    public static final MediaType FORM = MediaType.get("multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final String boundary;
    private final MediaType originalType;
    private final MediaType contentType;
    private final List<Part> parts;
    private long contentLength = -1L;

    MultipartBody(String string, MediaType mediaType, List<Part> list) {
        this.boundary = string;
        this.originalType = mediaType;
        this.contentType = MediaType.get(mediaType + "; boundary=" + string);
        this.parts = Collections.unmodifiableList(new ArrayList<Part>(list));
    }

    public final MediaType type() {
        return this.originalType;
    }

    public final String boundary() {
        return this.boundary;
    }

    public final int size() {
        return this.parts.size();
    }

    public final List<Part> parts() {
        return this.parts;
    }

    public final Part part(int n2) {
        return this.parts.get(n2);
    }

    @Override
    public final MediaType contentType() {
        return this.contentType;
    }

    @Override
    public final long contentLength() {
        long l2 = this.contentLength;
        if (l2 != -1L) {
            return l2;
        }
        try {
            this.contentLength = this.writeOrCountBytes(null, true);
            return this.contentLength;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        this.writeOrCountBytes(outputStream, false);
    }

    private long writeOrCountBytes(OutputStream outputStream, boolean bl) throws IOException {
        long l2 = 0L;
        BufferedSink bufferedSink = null;
        BufferedSink bufferedSink2 = bl ? (bufferedSink = new BufferedSink(new ByteArrayOutputStream())) : new BufferedSink(outputStream);
        int n2 = this.parts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            MediaType mediaType;
            Object object = this.parts.get(i2);
            Headers headers = ((Part)object).headers;
            object = ((Part)object).body;
            bufferedSink2.write(DASHDASH);
            bufferedSink2.write(this.boundary);
            bufferedSink2.write(CRLF);
            if (headers != null) {
                int n3 = headers.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink2.writeUtf8(headers.name(i3)).write(COLONSPACE).writeUtf8(headers.value(i3)).write(CRLF);
                }
            }
            if ((mediaType = ((RequestBody)object).contentType()) != null) {
                bufferedSink2.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(CRLF);
            }
            if ((l3 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink2.writeUtf8("Content-Length: ").writeLong(l3).write(CRLF);
            } else if (bl) {
                bufferedSink.close();
                return -1L;
            }
            bufferedSink2.write(CRLF);
            if (bl) {
                l2 += l3;
            } else {
                ((RequestBody)object).writeTo(outputStream);
            }
            bufferedSink2.write(CRLF);
        }
        bufferedSink2.write(DASHDASH);
        bufferedSink2.write(this.boundary);
        bufferedSink2.write(DASHDASH);
        bufferedSink2.write(CRLF);
        if (bl) {
            l2 += bufferedSink.size();
            bufferedSink.close();
        }
        return l2;
    }

    static void appendQuotedString(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("%0A");
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append("%0D");
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
    }

    public static final class Builder {
        private final String boundary;
        private MediaType type = FORM;
        private final List<Part> parts = new ArrayList<Part>();

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string) {
            this.boundary = string;
        }

        public final Builder setType(MediaType mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("type == null");
            }
            if (!mediaType.type().equals("multipart")) {
                throw new IllegalArgumentException("multipart != ".concat(String.valueOf(mediaType)));
            }
            this.type = mediaType;
            return this;
        }

        public final Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public final Builder addPart(Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public final Builder addFormDataPart(String string, String string2) {
            return this.addPart(Part.createFormData(string, string2));
        }

        public final Builder addFormDataPart(String string, String string2, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string, string2, requestBody));
        }

        public final Builder addPart(Part part) {
            if (part == null) {
                throw new NullPointerException("part == null");
            }
            this.parts.add(part);
            return this;
        }

        public final MultipartBody build() {
            if (this.parts.isEmpty()) {
                throw new IllegalStateException("Multipart body must have at least one part.");
            }
            return new MultipartBody(this.boundary, this.type, this.parts);
        }
    }

    public static final class Part {
        final Headers headers;
        final RequestBody body;

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part create(Headers headers, RequestBody requestBody) {
            if (requestBody == null) {
                throw new NullPointerException("body == null");
            }
            if (headers != null && headers.get("Content-Type") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Type");
            }
            if (headers != null && headers.get("Content-Length") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Length");
            }
            return new Part(headers, requestBody);
        }

        public static Part createFormData(String string, String string2) {
            return Part.createFormData(string, null, RequestBody.create(null, string2));
        }

        public static Part createFormData(String string, String string2, RequestBody requestBody) {
            return Part.createFormData(string, string2, requestBody, null);
        }

        public static Part createFormData(String object, String string, RequestBody requestBody, String string2) {
            if (object == null) {
                throw new NullPointerException("name == null");
            }
            StringBuilder stringBuilder = new StringBuilder("form-data; name=");
            MultipartBody.appendQuotedString(stringBuilder, (String)object);
            if (string != null) {
                stringBuilder.append("; filename=");
                MultipartBody.appendQuotedString(stringBuilder, string);
            }
            object = new Headers.Builder().addUnsafeNonAscii("Content-Disposition", stringBuilder.toString());
            if (string2 != null) {
                ((Headers.Builder)object).add("Content-Transfer-Encoding", string2);
            }
            return Part.create(((Headers.Builder)object).build(), requestBody);
        }

        private Part(Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        public final Headers headers() {
            return this.headers;
        }

        public final RequestBody body() {
            return this.body;
        }
    }
}

