/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.MediaType;
import com.getui.gtc.base.http.Util;
import com.getui.gtc.base.util.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    public abstract MediaType contentType();

    public abstract long contentLength();

    public abstract InputStream byteStream();

    public static ResponseBody create(MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = ((String)object).getBytes(charset);
        return ResponseBody.create(mediaType, (byte[])object);
    }

    public static ResponseBody create(MediaType mediaType, byte[] byArray) {
        return ResponseBody.create(mediaType, byArray.length, new ByteArrayInputStream(byArray));
    }

    public static ResponseBody create(final MediaType mediaType, final long l2, final InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("byte stream is null");
        }
        return new ResponseBody(){

            @Override
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return l2;
            }

            @Override
            public final InputStream byteStream() {
                return inputStream;
            }
        };
    }

    public final byte[] bytes() throws IOException {
        long l2 = this.contentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: ".concat(String.valueOf(l2)));
        }
        Object object = new ByteArrayOutputStream();
        InputStream inputStream = this.byteStream();
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n2);
            }
        }
        finally {
            Util.closeQuietly(inputStream);
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        if (l2 != -1L && l2 != (long)((Object)object).length) {
            throw new IOException("Content-Length (" + l2 + ") and stream length (" + ((Object)object).length + ") disagree");
        }
        return object;
    }

    public final String string() throws IOException {
        byte[] byArray = this.bytes();
        return new String(byArray, this.charset());
    }

    public final void file(File file) throws IOException {
        IOUtils.saveToFile(this.byteStream(), file);
    }

    public final Reader charStream() {
        return new InputStreamReader(this.byteStream(), this.charset());
    }

    public Charset charset() {
        MediaType mediaType = this.contentType();
        if (mediaType != null) {
            return mediaType.charset(Util.UTF_8);
        }
        return Util.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.byteStream());
    }
}

