/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class BufferedSink {
    public final OutputStream sink;
    private long size;

    BufferedSink(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("sink == null");
        }
        this.sink = outputStream;
        this.size = 0L;
    }

    public final BufferedSink write(String object) throws IOException {
        object = ((String)object).getBytes();
        this.sink.write((byte[])object);
        this.size += (long)((Object)object).length;
        return this;
    }

    public final BufferedSink writeUtf8(String object) throws IOException {
        object = ((String)object).getBytes();
        this.sink.write((byte[])object);
        this.size += (long)((Object)object).length;
        return this;
    }

    public final BufferedSink write(byte[] byArray) throws IOException {
        this.sink.write(byArray);
        this.size += (long)byArray.length;
        return this;
    }

    public final BufferedSink write(ByteBuffer object) throws IOException {
        object = ((ByteBuffer)object).array();
        this.sink.write((byte[])object);
        this.size += (long)((Object)object).length;
        return this;
    }

    public final BufferedSink writeLong(long l2) throws IOException {
        byte[] byArray = String.valueOf(l2).getBytes();
        this.sink.write(byArray);
        this.size += (long)byArray.length;
        return this;
    }

    public final long size() {
        return this.size;
    }

    public final void close() throws IOException {
        this.sink.close();
    }
}

