/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.Call;
import com.getui.gtc.base.http.RealCall;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private ExecutorService executorService;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public final synchronized ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
                AtomicInteger index = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable runnable) {
                    runnable = new Thread(runnable);
                    ((Thread)runnable).setName("GtHttpClient dispatcher's thread" + this.index.getAndIncrement());
                    return runnable;
                }
            });
        }
        return this.executorService;
    }

    public final synchronized void setMaxRequests(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("max < 1: ".concat(String.valueOf(n2)));
        }
        this.maxRequests = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public final synchronized void setMaxRequestsPerHost(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("max < 1: ".concat(String.valueOf(n2)));
        }
        this.maxRequestsPerHost = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    final synchronized void enqueue(RealCall.AsyncCall asyncCall) {
        if (this.runningAsyncCalls.size() < this.maxRequests && this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
            this.runningAsyncCalls.add(asyncCall);
            this.executorService().execute(asyncCall);
            return;
        }
        this.readyAsyncCalls.add(asyncCall);
    }

    public final synchronized void cancelAll() {
        Iterator<Object> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            iterator.next().get().cancel();
        }
        iterator = this.runningAsyncCalls.iterator();
        while (iterator.hasNext()) {
            iterator.next().get().cancel();
        }
        iterator = this.runningSyncCalls.iterator();
        while (iterator.hasNext()) {
            ((RealCall)iterator.next()).cancel();
        }
    }

    private void promoteCalls() {
        if (this.runningAsyncCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyAsyncCalls.isEmpty()) {
            return;
        }
        Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            RealCall.AsyncCall asyncCall = iterator.next();
            if (this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
                iterator.remove();
                this.runningAsyncCalls.add(asyncCall);
                this.executorService().execute(asyncCall);
            }
            if (this.runningAsyncCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(RealCall.AsyncCall asyncCall) {
        int n2 = 0;
        Iterator<RealCall.AsyncCall> iterator = this.runningAsyncCalls.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().get().request().url().getHost().equals(asyncCall.get().request().url().getHost())) continue;
            ++n2;
        }
        return n2;
    }

    final synchronized void executed(RealCall realCall) {
        this.runningSyncCalls.add(realCall);
    }

    final void finished(RealCall.AsyncCall asyncCall) {
        Dispatcher dispatcher = this;
        dispatcher.finished(dispatcher.runningAsyncCalls, asyncCall, true);
    }

    final void finished(RealCall realCall) {
        Dispatcher dispatcher = this;
        dispatcher.finished(dispatcher.runningSyncCalls, realCall, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finished(Deque<T> deque, T t, boolean bl) {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!deque.remove(t)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            if (bl) {
                this.promoteCalls();
            }
            return;
        }
    }

    public final synchronized List<Call> queuedCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized List<Call> runningCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        arrayList.addAll(this.runningSyncCalls);
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public final synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

