/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http.crypt;

import android.util.Base64;
import com.getui.gtc.base.crypt.CryptTools;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.RequestBody;
import com.getui.gtc.base.http.Response;
import com.getui.gtc.base.http.ResponseBody;
import com.getui.gtc.base.http.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PtRASCryptoInterceptor
implements Interceptor {
    private String publicKeyStr;
    private String keyId;
    private PublicKey rsaPublicKey;
    private SecretKey aesKey;
    private String encryptedAesKey;

    public PtRASCryptoInterceptor(String string, String string2) {
        this.keyId = string;
        this.publicKeyStr = string2;
        try {
            this.rsaPublicKey = CryptTools.parsePublicKey("RSA", string2);
            this.aesKey = CryptTools.generateKey("AES", 128);
            this.encryptedAesKey = Base64.encodeToString((byte[])CryptTools.encrypt("RSA/NONE/OAEPWithSHA1AndMGF1Padding", this.rsaPublicKey, this.aesKey.getEncoded()), (int)2);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        Object object2 = object.request();
        Object object3 = ((Request)object2).newBuilder();
        RequestBody requestBody = ((Request)object2).body();
        if (requestBody == null) {
            throw new RuntimeException("PtRASCryptoInterceptor Error: request body is null");
        }
        Object object4 = new ByteArrayOutputStream();
        requestBody.writeTo((OutputStream)object4);
        Util.closeQuietly((Closeable)object4);
        object4 = ((ByteArrayOutputStream)object4).toByteArray();
        Object object5 = new String((byte[])object4, requestBody.contentType().charset());
        try {
            boolean bl = ((Request)object2).url().toString().toLowerCase().startsWith("https");
            ((Request.Builder)object3).addHeader("X-TP", bl ? "4" : "3").addHeader("X-KD", this.keyId).addHeader("X-V", "1.0.1.0");
            if (!bl) {
                ((Request.Builder)object3).addHeader("X-TL", "10");
                this.aesKey = CryptTools.generateKey("AES", 128);
                this.encryptedAesKey = Base64.encodeToString((byte[])CryptTools.encrypt("RSA/NONE/OAEPWithSHA1AndMGF1Padding", this.rsaPublicKey, this.aesKey.getEncoded()), (int)2);
            }
            ((Request.Builder)object3).addHeader("X-AK", this.encryptedAesKey);
            String string = Base64.encodeToString((byte[])this.aesKey.getEncoded(), (int)2);
            object5 = Base64.encodeToString((byte[])CryptTools.digest("SHA256", (this.keyId + string + (String)object5).getBytes()), (int)2);
            ((Request.Builder)object3).addHeader("X-SG", (String)object5);
            object5 = new IvParameterSpec(CryptTools.digest("md5", ((String)object5).getBytes()));
            object4 = CryptTools.encrypt("AES/CFB/NoPadding", this.aesKey, (IvParameterSpec)object5, (byte[])object4);
            ((Request.Builder)object3).body(RequestBody.create(requestBody.contentType(), (byte[])object4));
            object = object.proceed(((Request.Builder)object3).build());
            if (((Response)object).code() != 200) {
                return object;
            }
            object2 = ((Response)object).newBuilder().request((Request)object2);
            object3 = ((Response)object).body().bytes();
            object3 = CryptTools.decrypt("AES/CFB/NoPadding", this.aesKey, (IvParameterSpec)object5, (byte[])object3);
            ((Response.Builder)object2).body(ResponseBody.create(((Response)object).body().contentType(), (byte[])object3));
            return ((Response.Builder)object2).build();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("PtRASCryptoInterceptor Error", generalSecurityException);
        }
    }
}

