/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.base.scheduler;

import com.igexin.base.api.GTSchedulerManager;
import com.igexin.base.scheduler.b;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseTask
implements Runnable {
    private static final String TAG = "BaseTask";
    private b.a mParent;
    private volatile int isRunVal;
    private String groupName;
    private long period;
    private long initDelay;
    private AtomicBoolean isCanceled = new AtomicBoolean();
    private GTSchedulerManager.TASKLEVEL taskLevel = GTSchedulerManager.TASKLEVEL.LEVEL_DEFAULT;

    public BaseTask(long l2, TimeUnit timeUnit) {
        this.setDelayImpl(l2, 0L, timeUnit, true);
    }

    public BaseTask(long l2, long l3, TimeUnit timeUnit, boolean bl) {
        this.setDelayImpl(l2, l3, timeUnit, bl);
    }

    public void setDelay(long l2, TimeUnit timeUnit) {
        this.setDelayImpl(l2, 0L, timeUnit, true);
    }

    public void setDelay(long l2, long l3, TimeUnit timeUnit, boolean bl) {
        this.setDelayImpl(l2, l3, timeUnit, bl);
    }

    private void setDelayImpl(long l2, long l3, TimeUnit timeUnit, boolean bl) {
        this.initDelay = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
        this.period = (long)(bl ? 1 : -1) * TimeUnit.MILLISECONDS.convert(l3, timeUnit);
    }

    void bind(b.a a2) {
        if (a2 == null) {
            return;
        }
        this.mParent = a2;
    }

    public void setIsRunning(boolean bl) {
        this.isRunVal = bl ? 1 : 0;
    }

    public boolean isRunning() {
        return this.isRunVal != 0;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public int getTaskLevel() {
        return this.taskLevel.val;
    }

    public void setTaskLevel(GTSchedulerManager.TASKLEVEL tASKLEVEL) {
        this.taskLevel = tASKLEVEL;
    }

    protected abstract void onRunTask();

    protected void done() {
    }

    protected void onCancel() {
    }

    protected void onException(Throwable throwable) {
    }

    public boolean cancel() {
        if (this.mParent != null) {
            return this.mParent.cancel(false);
        }
        this.isCanceled.set(true);
        return true;
    }

    public boolean interrupt() {
        if (this.mParent != null) {
            return this.mParent.cancel(true);
        }
        this.isCanceled.set(true);
        return true;
    }

    public long getInitDelay() {
        return this.initDelay;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isPeriodic() {
        return this.period != 0L;
    }

    @Override
    public final void run() {
        if (this.isCanceled.get()) {
            return;
        }
        this.setIsRunning(true);
        this.onRunTask();
    }
}

