/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.sdk;

import android.app.Application;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.getui.gtc.base.GtcProvider;
import com.getui.gtc.base.util.CommonUtil;
import com.igexin.push.core.ServiceManager;
import com.igexin.push.core.f;
import com.igexin.push.f.b;
import com.igexin.push.f.c;
import com.igexin.push.f.k;
import com.igexin.push.f.m;
import com.igexin.sdk.GTIntentService;
import com.igexin.sdk.GetuiPushException;
import com.igexin.sdk.PushConsts;
import com.igexin.sdk.PushService;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.Label;
import com.igexin.sdk.message.SetFenceLabelMessage;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import org.json.JSONArray;

public class PushManager {
    private static final String TAG = "PushManager";
    private long lastSetTagTime;
    private long lastSendMessageTime;
    private long lastOpAliasTime;
    private long lastQueryTagTime = 0L;
    private byte[] keyBytes;
    private String uIntentService;
    private Class uPushService;
    private String uActivity;
    private String uRegisterService;
    private volatile f callback;
    private String safeCode;
    private long lastSetFenceLabelsTime;

    public static PushManager getInstance() {
        return a.a;
    }

    private PushManager() {
    }

    public void initialize(Context context) {
        try {
            Class clazz;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            ServiceManager.getInstance().f(context);
            if (TextUtils.isEmpty((CharSequence)this.uIntentService) && (clazz = (Class)b.a((Context)context, GTIntentService.class).second) != null) {
                this.uIntentService = clazz.getName();
            }
            if (this.uPushService == null) {
                this.uPushService = (Class)b.a((Context)context, PushService.class).second;
            }
            this.initialize(context, this.uPushService);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Deprecated
    public <T extends Service> void initialize(Context context, Class<T> clazz) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (!this.checkGTCVersion()) {
                return;
            }
            ServiceManager.getInstance().f(context);
            if (clazz == null || com.igexin.push.core.a.E.equals(clazz.getName())) {
                clazz = PushService.class;
            }
            ComponentName componentName = new ComponentName(context, clazz);
            context.getPackageManager().setComponentEnabledSetting(componentName, 1, 1);
            componentName = new Intent(context.getApplicationContext(), clazz);
            componentName.putExtra("action", PushConsts.ACTION_SERVICE_INITIALIZE);
            componentName.putExtra("ups", clazz.getName());
            if (this.uIntentService != null) {
                componentName.putExtra("uis", this.uIntentService);
            }
            if (!TextUtils.isEmpty((CharSequence)this.uActivity)) {
                componentName.putExtra("ua", this.uActivity);
            }
            if (!TextUtils.isEmpty((CharSequence)this.uRegisterService)) {
                componentName.putExtra("us", this.uRegisterService);
            }
            if (this.startService(context, (Intent)componentName)) {
                this.uPushService = clazz;
            }
            this.registerCallback(context);
            return;
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
            return;
        }
    }

    public boolean isPushTurnedOn(Context context) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            ServiceManager.b = context.getApplicationContext();
            return com.igexin.push.core.c.a.a().b("p");
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
            return false;
        }
    }

    public String getVersion(Context context) {
        return "3.3.9.5";
    }

    public synchronized String getClientid(Context context) {
        try {
            Object object;
            Object object2;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (this.keyBytes == null) {
                try {
                    object2 = k.b(context);
                    if (object2 != null && object2.metaData != null) {
                        String string;
                        object = b.a(object2);
                        if (TextUtils.isEmpty((CharSequence)object)) {
                            object = object2.metaData.getString("PUSH_APPID");
                        }
                        if (TextUtils.isEmpty((CharSequence)object)) {
                            object = object2.metaData.getString("GETUI_APPID");
                        }
                        if (object != null) {
                            object = ((String)object).trim();
                        }
                        if (!TextUtils.isEmpty((CharSequence)object) && (string = com.igexin.b.b.a.a((String)object + context.getPackageName())) != null) {
                            this.keyBytes = string.getBytes();
                        }
                    }
                }
                catch (Exception exception) {
                    com.igexin.b.a.c.a.a("PushManager|" + exception.toString(), new Object[0]);
                }
            }
            if (this.keyBytes != null) {
                ServiceManager.b = context.getApplicationContext();
                if (TextUtils.isEmpty((CharSequence)com.igexin.push.core.c.a.a().a("c"))) {
                    return "";
                }
                byte[] byArray = Base64.decode((String)com.igexin.push.core.c.a.a().a("c"), (int)0);
                object2 = byArray;
                if (byArray != null && this.keyBytes.length == ((ApplicationInfo)object2).length) {
                    object = new byte[((ApplicationInfo)object2).length];
                    for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                        object[i2] = (byte)(this.keyBytes[i2] ^ object2[i2]);
                    }
                    String string = new String((byte[])object);
                    if (Pattern.matches("[a-zA-Z0-9]+", string)) {
                        return new String((byte[])object);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
        }
        return null;
    }

    private boolean startService(Context context, Intent intent) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.safeCode)) {
                this.safeCode = m.b(context, "sc", "").toString();
                if (TextUtils.isEmpty((CharSequence)this.safeCode)) {
                    KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                    keyGenerator.init(128);
                    this.safeCode = c.a(keyGenerator.generateKey().getEncoded());
                    m.a(context, "sc", this.safeCode);
                }
            }
            intent.putExtra("sc", this.safeCode);
        }
        catch (Exception exception) {
            com.igexin.b.a.c.a.a(exception);
        }
        if (!this.checkGTCVersion()) {
            return false;
        }
        return ServiceManager.getInstance().a(context, intent);
    }

    private void sendResult(Context context, GTCmdMessage gTCmdMessage) {
        try {
            Class clazz = ServiceManager.getInstance().c(context);
            if (clazz != null && context != null) {
                clazz = new Intent(context, clazz);
                Bundle bundle = new Bundle();
                bundle.putInt("action", 10010);
                bundle.putSerializable("cmd_msg", (Serializable)gTCmdMessage);
                clazz.putExtras(bundle);
                context.startService((Intent)clazz);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.b.a.c.a.a(throwable);
            com.igexin.b.a.c.a.a("PushManager|" + throwable2.toString(), new Object[0]);
            return;
        }
    }

    private Class getUserPushService(Context context) {
        PushManager.checkContext(context);
        if (this.uPushService != null) {
            return this.uPushService;
        }
        return ServiceManager.getInstance().b(context);
    }

    private void registerCallback(final Context context) {
        ServiceManager.b = context.getApplicationContext();
        com.igexin.a.a.a().a("GTALCallback").execute(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (PushManager.this.callback != null || Build.VERSION.SDK_INT < 14) {
                        return;
                    }
                    Application application = PushManager.this.getMainApplication(context);
                    if (application == null) {
                        return;
                    }
                    if (PushManager.this.callback == null && application != null) {
                        PushManager.this.callback = new f();
                        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)PushManager.this.callback);
                        com.igexin.b.a.c.a.a("PushManager\uff5c registerCallback ", new Object[0]);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    com.igexin.b.a.c.a.a(throwable);
                    return;
                }
            }
        });
    }

    private void unRegisterCallback(final Context context) {
        com.igexin.a.a.a().a("GTALCallback").execute(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (PushManager.this.callback == null || Build.VERSION.SDK_INT < 14) {
                        return;
                    }
                    Application application = PushManager.this.getMainApplication(context);
                    if (application == null) {
                        return;
                    }
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)PushManager.this.callback);
                    PushManager.this.callback = null;
                    System.currentTimeMillis();
                    com.igexin.b.a.c.a.a("PushManager | unRegisterCallback time= " + System.currentTimeMillis(), new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    com.igexin.b.a.c.a.a(throwable);
                    return;
                }
            }
        });
    }

    private boolean checkGTCVersion() {
        return !b.a("3.2.5.0");
    }

    private Application getMainApplication(Context context) {
        if (context == null || !this.isMainProcess(context)) {
            return null;
        }
        if (context instanceof Application) {
            return (Application)context;
        }
        return (Application)context.getApplicationContext();
    }

    private boolean isMainProcess(Context context) {
        try {
            GtcProvider.setContext((Context)context);
            return CommonUtil.isMainProcess();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void checkContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("NULL context");
        }
    }

    public void checkManifest(Context context) throws GetuiPushException {
        if (this.isMainProcess(context)) {
            com.igexin.push.f.a.b(context);
        }
    }

    @Deprecated
    public <T extends GTIntentService> void registerPushIntentService(Context context, Class<T> intent) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            com.igexin.b.a.c.a.a("PushManager|call registerPushIntentService", new Object[0]);
            if (intent != null) {
                try {
                    Class.forName(intent.getName());
                }
                catch (Exception exception) {
                    com.igexin.b.a.c.a.a("PushManager|registerPushIntentService|" + exception.toString(), new Object[0]);
                    return;
                }
                if (!com.igexin.push.f.a.a(new Intent(context, intent), context)) {
                    return;
                }
                this.uIntentService = intent.getName();
            } else {
                this.uIntentService = "";
            }
            if (this.uPushService != null) {
                com.igexin.b.a.c.a.b(TAG, "start service to save intent service");
                intent = new Intent(context.getApplicationContext(), this.uPushService);
                intent.putExtra("uis", this.uIntentService);
                this.startService(context, intent);
            }
            return;
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
            return;
        }
    }

    public boolean preInit(Context context) {
        try {
            Class clazz;
            context = context.getApplicationContext();
            if (TextUtils.isEmpty((CharSequence)this.uIntentService) && (clazz = (Class)b.a((Context)context, GTIntentService.class).second) != null) {
                this.uIntentService = clazz.getName();
            }
            if (this.uPushService == null) {
                this.uPushService = (Class)b.a((Context)context, PushService.class).second;
            }
            return true;
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
            return false;
        }
    }

    public boolean setFenceLabels(Context context, List<Label> object) {
        try {
            Object object2;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (object == null) {
                com.igexin.b.a.c.a.a("PushManager|labels is null", new Object[0]);
                this.sendFenceLabelResult(context, "40001");
                return false;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastSetFenceLabelsTime < 1000L) {
                this.sendFenceLabelResult(context, "40002");
                return false;
            }
            if (object.size() == 0 || object.size() > 100) {
                this.sendFenceLabelResult(context, "40011");
                return false;
            }
            JSONArray jSONArray = object.iterator();
            while (jSONArray.hasNext()) {
                object2 = jSONArray.next();
                if (!(object2 == null || TextUtils.isEmpty((CharSequence)((Label)object2).getTagName()) || ((Label)object2).getTagName().length() > 32 || ((Label)object2).getTagName().matches(".*[\n\r].*") || TextUtils.isEmpty((CharSequence)((Label)object2).getTagId()) || ((Label)object2).getTagId().length() > 32 || ((Label)object2).getTagId().startsWith("g_") || !((Label)object2).getTagId().matches("^[a-zA-Z0-9_-]+$") || !TextUtils.isEmpty((CharSequence)((Label)object2).getTagVersion()) && (((Label)object2).getTagVersion().matches(".*[\n\r].*") || ((Label)object2).getTagVersion().length() > 32) || !TextUtils.isEmpty((CharSequence)((Label)object2).getExtraData()) && ((Label)object2).getExtraData().matches(".*[\n\r].*") || ((Label)object2).getEndTime() <= 0L)) continue;
                this.sendFenceLabelResult(context, "40011");
                return false;
            }
            jSONArray = new JSONArray();
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = (Label)object2.next();
                jSONArray.put((Object)((Label)object).getJsonObject());
            }
            this.lastSetFenceLabelsTime = l2;
            object2 = new Bundle();
            object2.putString("action", "setFenceLabels");
            object2.putString("labels", jSONArray.toString());
            object = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            object.putExtra("action", "com.igexin.sdk.action.pushmanager");
            object.putExtra("bundle", (Bundle)object2);
            this.startService(context, (Intent)object);
            return true;
        }
        catch (Throwable throwable) {
            com.igexin.b.a.c.a.a(throwable);
            return false;
        }
    }

    private void sendFenceLabelResult(Context context, String string) {
        this.sendResult(context, new SetFenceLabelMessage(string, 40009));
    }

    static final class a {
        private static final PushManager a = new PushManager();

        private a() {
        }
    }
}

