/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.getui.gtc.base.GtcProvider;
import com.getui.gtc.base.util.CommonUtil;
import com.getui.gtc.dim.Caller;
import com.getui.gtc.dim.DimManager;
import com.igexin.c.a.c.a.c;
import com.igexin.c.a.c.a.e;
import com.igexin.push.core.ServiceManager;
import com.igexin.push.core.b;
import com.igexin.push.core.d.d;
import com.igexin.push.core.h;
import com.igexin.push.g.f;
import com.igexin.push.g.o;
import com.igexin.push.g.q;
import com.igexin.sdk.GTIntentService;
import com.igexin.sdk.GetuiPushException;
import com.igexin.sdk.IUserLoggerInterface;
import com.igexin.sdk.PushConsts;
import com.igexin.sdk.PushService;
import com.igexin.sdk.Tag;
import com.igexin.sdk.message.BindAliasCmdMessage;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.Label;
import com.igexin.sdk.message.SetFenceLabelMessage;
import com.igexin.sdk.message.SetTagCmdMessage;
import com.igexin.sdk.message.UnBindAliasCmdMessage;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import org.json.JSONArray;

public class PushManager {
    private static final String TAG = "PushManager";
    private long lastSetTagTime;
    private long lastSendMessageTime;
    private long lastOpAliasTime;
    private long lastQueryTagTime = 0L;
    private byte[] keyBytes;
    private String uIntentService;
    private Class uPushService;
    private String uActivity;
    private String uRegisterService;
    private volatile h callback;
    private String safeCode;
    private long lastSetFenceLabelsTime;

    public static PushManager getInstance() {
        return a.a;
    }

    private PushManager() {
    }

    public void initialize(Context context) {
        try {
            Class clazz;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            ServiceManager.getInstance().f(context);
            if (TextUtils.isEmpty((CharSequence)this.uIntentService) && (clazz = (Class)com.igexin.push.g.d.a((Context)context, GTIntentService.class).second) != null) {
                this.uIntentService = clazz.getName();
            }
            if (this.uPushService == null) {
                this.uPushService = (Class)com.igexin.push.g.d.a((Context)context, PushService.class).second;
            }
            this.initialize(context, this.uPushService);
            return;
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] initialize sdk error = " + throwable.toString());
            return;
        }
    }

    @Deprecated
    public <T extends Service> void initialize(Context object, Class<T> object2) {
        try {
            PushManager.checkContext(object);
            GtcProvider.setContext((Context)object);
            if (!this.checkGTCVersion()) {
                return;
            }
            ServiceManager.getInstance().f((Context)object);
            if (object2 == null || b.ao.equals(((Class)object2).getName())) {
                object2 = PushService.class;
            }
            ComponentName componentName = new ComponentName(object, (Class)object2);
            object.getPackageManager().setComponentEnabledSetting(componentName, 1, 1);
            componentName = new Intent(object.getApplicationContext(), (Class)object2);
            componentName.putExtra("action", PushConsts.ACTION_SERVICE_INITIALIZE);
            componentName.putExtra("ups", ((Class)object2).getName());
            if (this.uIntentService != null) {
                componentName.putExtra("uis", this.uIntentService);
            }
            if (!TextUtils.isEmpty((CharSequence)this.uActivity)) {
                componentName.putExtra("ua", this.uActivity);
            }
            if (!TextUtils.isEmpty((CharSequence)this.uRegisterService)) {
                componentName.putExtra("us", this.uRegisterService);
            }
            if (this.startService((Context)object, (Intent)componentName)) {
                this.uPushService = object2;
            }
            this.registerCallback((Context)object);
            try {
                object2 = object;
                object = com.igexin.d.a.a();
                com.igexin.d.a.a().a = object2.getApplicationContext();
                com.igexin.b.a.a().b().schedule(new Runnable((com.igexin.d.a)object){
                    final /* synthetic */ com.igexin.d.a a;
                    {
                        this.a = a2;
                    }

                    public final void run() {
                        try {
                            if (com.igexin.d.a.a(com.igexin.d.a.a(this.a))) {
                                com.igexin.d.a.a(this.a, com.igexin.d.a.a(this.a));
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            com.igexin.c.a.c.a.a(throwable);
                            return;
                        }
                    }
                }, 2000L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] initialize sdk error = " + ((Throwable)object2).toString());
            return;
        }
    }

    private <T extends Activity> void registerPushActivity(Context context, Class<T> serializable) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (serializable != null) {
                try {
                    Class.forName(((Class)serializable).getName());
                }
                catch (Exception exception) {
                    c.a().a("[PushManager] can't load activity = " + exception.toString());
                    com.igexin.c.a.c.a.a("PushManager|registerPushActivity|" + exception.toString(), new Object[0]);
                    return;
                }
                this.uActivity = ((Class)serializable).getName();
            } else {
                c.a().a("[PushManager] call -> registerPushActivity, parameter [activity] is null");
                this.uActivity = "";
            }
            if (this.uPushService != null) {
                serializable = new Bundle();
                serializable.putString("action", "registerPushActivity");
                serializable.putString("ua", this.uActivity);
                Intent intent = new Intent(context.getApplicationContext(), this.uPushService);
                intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
                intent.putExtra("bundle", (Bundle)serializable);
                intent.putExtra("ua", this.uActivity);
                this.startService(context, intent);
            }
            return;
        }
        catch (Throwable throwable) {
            serializable = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] registerPushActivity sdk error = " + ((Throwable)serializable).toString());
            return;
        }
    }

    private <T extends Service> void registerUserService(Context context, Class<T> serializable) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (serializable != null) {
                try {
                    Class.forName(((Class)serializable).getName());
                }
                catch (Exception exception) {
                    c.a().a("[PushManager] can't load service = " + exception.toString());
                    com.igexin.c.a.c.a.a("PushManager|registerUserService|" + exception.toString(), new Object[0]);
                    return;
                }
                this.uRegisterService = ((Class)serializable).getName();
            } else {
                c.a().a("[PushManager] call -> registerUserService, parameter [service] is null");
                this.uRegisterService = "";
            }
            if (this.uPushService != null) {
                serializable = new Bundle();
                serializable.putString("action", "registerUserService");
                serializable.putString("us", this.uRegisterService);
                Intent intent = new Intent(context.getApplicationContext(), this.uPushService);
                intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
                intent.putExtra("bundle", (Bundle)serializable);
                intent.putExtra("us", this.uRegisterService);
                this.startService(context, intent);
            }
            return;
        }
        catch (Throwable throwable) {
            serializable = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] registerUserService  error = " + ((Throwable)serializable).toString());
            return;
        }
    }

    public void turnOnPush(Context context) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("PushManager|call turnOnPush");
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.action.initialize.slave");
            intent.putExtra("op_app", context.getApplicationContext().getPackageName());
            intent.putExtra("isSlave", true);
            this.startService(context, intent);
            this.registerCallback(context);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] turnOnPush  error = " + throwable2.toString());
            return;
        }
    }

    public void turnOffPush(Context context) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("PushManager|call turnOffPush");
            Bundle bundle = new Bundle();
            bundle.putString("action", "turnOffPush");
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            this.startService(context, intent);
            this.unRegisterCallback(context);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] turnOffPush  error = " + throwable2.toString());
            return;
        }
    }

    public boolean isPushTurnedOn(Context object) {
        try {
            PushManager.checkContext((Context)object);
            GtcProvider.setContext((Context)object);
            ServiceManager.b = object.getApplicationContext();
            return d.a().b("p");
        }
        catch (Throwable throwable) {
            object = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] turnOffPush  error = " + ((Throwable)object).toString());
            return false;
        }
    }

    public String getVersion(Context context) {
        return "3.3.12.0";
    }

    public int setTag(Context context, Tag[] bundle, String string) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (bundle == null) {
                c.a().a("[PushManager] call -> setTag failed, parameter [tags] is null");
                com.igexin.c.a.c.a.a("PushManager|tags is null", new Object[0]);
                this.sendSetTagResult(context, string, "20006");
                return 20006;
            }
            if (string == null) {
                c.a().a("[PushManager] call -> setTag failed, parameter [sn] is null");
                this.sendSetTagResult(context, string, "20007");
                return 20007;
            }
            if ((long)((Tag[])bundle).length > 200L) {
                c.a().a("[PushManager] call -> setTag failed, parameter [tags] len > 200 is exceeds");
                this.sendSetTagResult(context, string, "20001");
                return 20001;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastSetTagTime < 1000L) {
                c.a().a("[PushManager] call - > setTag failed, it be called too frequently");
                this.sendSetTagResult(context, string, "20002");
                return 20002;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Tag tag : bundle) {
                if (tag == null || tag.getName() == null) continue;
                if (tag.getName().contains(" ") || tag.getName().contains(",")) {
                    c.a().a("[PushManager] call -> setTag failed, the tag [" + tag.getName() + "] is not illegal");
                    this.sendSetTagResult(context, string, "20011");
                    return 20011;
                }
                stringBuilder.append(tag.getName());
                stringBuilder.append(",");
            }
            if (stringBuilder.length() <= 0) {
                this.sendSetTagResult(context, string, "20006");
                return 20006;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
            c.a().a("[PushManager] call setTag");
            bundle = new Bundle();
            bundle.putString("action", "setTag");
            bundle.putString("tags", stringBuilder.toString());
            bundle.putString("sn", string);
            this.lastSetTagTime = l2;
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            this.startService(context, intent);
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setTag  error = " + throwable2.toString());
            return 20005;
        }
    }

    public int queryTag(Context context, String string) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (string == null) {
                c.a().a("[PushManager]call -> queryTag failed, parameter [sn] is null");
                return 20007;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastQueryTagTime < 1000L) {
                c.a().a("[PushManager]call -> queryTag failed, it be called too frequently");
                return 20002;
            }
            Bundle bundle = new Bundle();
            bundle.putString("action", "queryTag");
            bundle.putString("sn", string);
            this.lastQueryTagTime = l2;
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] queryTag  error = " + throwable2.toString());
        }
        return 0;
    }

    public boolean setSilentTime(Context context, int n2, int n3) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (n2 < 0 || n2 >= 24 || n3 < 0 || n3 > 23) {
                c.a().a("[PushManager] call - > setSilentTime failed, parameter [beginHour] or [duration] value exceeding");
                return false;
            }
            Bundle bundle = new Bundle();
            bundle.putString("action", "setSilentTime");
            bundle.putInt("beginHour", n2);
            bundle.putInt("duration", n3);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] queryTag  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setHeartbeatInterval(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (n2 < 0) {
                c.a().a("[PushManager] call -> setHeartbeatInterval failed, parameter [interval] < 0, illegal");
                return false;
            }
            Bundle bundle = new Bundle();
            bundle.putString("action", "setHeartbeatInterval");
            bundle.putInt("interval", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setHeartbeatInterval  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setSocketTimeout(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (n2 < 0) {
                c.a().a("[PushManager] call - > setSocketTimeout failed, parameter [timeout] < 0, illegal");
                return false;
            }
            Bundle bundle = new Bundle();
            bundle.putString("action", "setSocketTimeout");
            bundle.putInt("timeout", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setSocketTimeout  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean sendMessage(Context context, String string, byte[] byArray) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            long l2 = System.currentTimeMillis();
            if (string == null || byArray == null || (long)byArray.length > 4096L || l2 - this.lastSendMessageTime < 1000L) {
                c.a().a("[PushManager] call - > sendMessage failed, parameter is illegal or it be called too frequently");
                return false;
            }
            this.lastSendMessageTime = l2;
            Bundle bundle = new Bundle();
            bundle.putString("action", "sendMessage");
            bundle.putString("taskid", string);
            bundle.putByteArray("extraData", byArray);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] sendMessage  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean sendFeedbackMessage(Context context, String string, String string2, int n2) {
        try {
            boolean bl;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            boolean bl2 = bl = n2 >= 60001 && n2 <= 60999 || n2 >= 90001 && n2 <= 90999;
            if (string == null || string2 == null || !bl) {
                c.a().a("[PushManager] call - > sendFeedbackMessage failed, parameter is illegal");
                return false;
            }
            n2 = this.getAssistAction(n2, string2);
            Bundle bundle = new Bundle();
            bundle.putString("action", "sendFeedbackMessage");
            bundle.putString("taskid", string);
            bundle.putString("messageid", string2);
            bundle.putString("actionid", String.valueOf(n2));
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] sendFeedbackMessage  error = " + throwable2.toString());
            return false;
        }
    }

    public synchronized String getClientid(Context object) {
        try {
            Object object2;
            Object object3;
            PushManager.checkContext((Context)object);
            GtcProvider.setContext((Context)object);
            if (this.keyBytes == null) {
                try {
                    object3 = o.b((Context)object);
                    if (object3 != null && object3.metaData != null) {
                        String string;
                        object2 = com.igexin.push.g.d.a(object3);
                        if (TextUtils.isEmpty((CharSequence)object2)) {
                            object2 = object3.metaData.getString("PUSH_APPID");
                        }
                        if (TextUtils.isEmpty((CharSequence)object2)) {
                            object2 = object3.metaData.getString("GETUI_APPID");
                        }
                        if (object2 != null) {
                            object2 = ((String)object2).trim();
                        }
                        if (!TextUtils.isEmpty((CharSequence)object2) && (string = com.igexin.c.b.a.a((String)object2 + object.getPackageName())) != null) {
                            this.keyBytes = string.getBytes();
                        }
                    }
                }
                catch (Exception exception) {
                    com.igexin.c.a.c.a.a("PushManager|" + exception.toString(), new Object[0]);
                }
            }
            if (this.keyBytes != null) {
                ServiceManager.b = object.getApplicationContext();
                if (TextUtils.isEmpty((CharSequence)d.a().a("c"))) {
                    return "";
                }
                byte[] byArray = Base64.decode((String)d.a().a("c"), (int)0);
                object3 = byArray;
                if (byArray != null && this.keyBytes.length == ((ApplicationInfo)object3).length) {
                    object2 = new byte[((ApplicationInfo)object3).length];
                    for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                        object2[i2] = (byte)(this.keyBytes[i2] ^ object3[i2]);
                    }
                    String string = new String((byte[])object2);
                    if (Pattern.matches("[a-zA-Z0-9]+", string)) {
                        return new String((byte[])object2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] getClientid  error = " + ((Throwable)object).toString());
        }
        return null;
    }

    public boolean bindAlias(Context context, String string) {
        return this.bindAlias(context, string, "bindAlias_" + System.currentTimeMillis());
    }

    public boolean bindAlias(Context context, String string, String string2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("PushManager|call bindAlias");
            com.igexin.c.a.c.a.a("PushManager|call bindAlias", new Object[0]);
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastOpAliasTime < 1000L) {
                c.a().a("[PushManager] call - > bindAlias failed, it be called too frequently");
                this.sendBindAliasResult(context, string2, "30001");
                return false;
            }
            this.lastOpAliasTime = l2;
            Bundle bundle = new Bundle();
            bundle.putString("action", "bindAlias");
            bundle.putString("alias", string);
            bundle.putString("sn", string2);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] bindAlias  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean unBindAlias(Context context, String string, boolean bl) {
        return this.unBindAlias(context, string, bl, "unBindAlias_" + System.currentTimeMillis());
    }

    public boolean unBindAlias(Context context, String string, boolean bl, String string2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("PushManager|call unBindAlias");
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastOpAliasTime < 1000L) {
                c.a().a("[PushManager] call - > unBindAlias failed, it be called too frequently");
                this.sendUnBindAliasResult(context, string2, "30001");
                return false;
            }
            this.lastOpAliasTime = l2;
            Bundle bundle = new Bundle();
            bundle.putString("action", "unbindAlias");
            bundle.putString("alias", string);
            bundle.putBoolean("isSeft", bl);
            bundle.putString("sn", string2);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] unBindAlias  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean sendApplinkFeedback(Context context, String string) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                c.a().a("[PushManager] call - > sendApplinkFeedback failed, parameter is illegal");
                return false;
            }
            Bundle bundle = new Bundle();
            bundle.putString("action", "sendApplinkFeedback");
            bundle.putString("url", string);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] sendApplinkFeedback  error = " + throwable2.toString());
            return false;
        }
    }

    private boolean startService(Context context, Intent intent) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.safeCode)) {
                this.safeCode = q.b(context, "sc", "").toString();
                if (TextUtils.isEmpty((CharSequence)this.safeCode)) {
                    KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                    keyGenerator.init(128);
                    this.safeCode = com.igexin.push.g.e.a(keyGenerator.generateKey().getEncoded());
                    q.a(context, "sc", this.safeCode);
                }
            }
            intent.putExtra("sc", this.safeCode);
        }
        catch (Exception exception) {
            com.igexin.c.a.c.a.a(exception);
        }
        if (!this.checkGTCVersion()) {
            return false;
        }
        return ServiceManager.getInstance().b(context, intent);
    }

    private void sendBindAliasResult(Context context, String string, String string2) {
        this.sendResult(context, new BindAliasCmdMessage(string, string2, 10010));
    }

    private void sendUnBindAliasResult(Context context, String string, String string2) {
        this.sendResult(context, new UnBindAliasCmdMessage(string, string2, 10011));
    }

    private void sendSetTagResult(Context context, String string, String string2) {
        this.sendResult(context, new SetTagCmdMessage(string, string2, 10009));
    }

    private void sendResult(Context context, GTCmdMessage gTCmdMessage) {
        try {
            Class clazz = ServiceManager.getInstance().c(context);
            if (clazz != null && context != null) {
                clazz = new Intent(context, clazz);
                Bundle bundle = new Bundle();
                bundle.putInt("action", 10010);
                bundle.putSerializable("cmd_msg", (Serializable)gTCmdMessage);
                clazz.putExtras(bundle);
                context.startService((Intent)clazz);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            com.igexin.c.a.c.a.a("PushManager|" + throwable2.toString(), new Object[0]);
            return;
        }
    }

    private Class getUserPushService(Context context) {
        PushManager.checkContext(context);
        if (this.uPushService != null) {
            return this.uPushService;
        }
        return ServiceManager.getInstance().b(context);
    }

    private void registerCallback(final Context context) {
        ServiceManager.b = context.getApplicationContext();
        com.igexin.b.a.a().a("GTALCallback").execute(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (PushManager.this.callback != null || Build.VERSION.SDK_INT < 14) {
                        return;
                    }
                    Application application = PushManager.this.getMainApplication(context);
                    if (application == null) {
                        return;
                    }
                    if (PushManager.this.callback == null && application != null) {
                        PushManager.this.callback = new h();
                        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)PushManager.this.callback);
                        com.igexin.c.a.c.a.a("PushManager\uff5c registerCallback ", new Object[0]);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    com.igexin.c.a.c.a.a(throwable);
                    return;
                }
            }
        });
    }

    private void unRegisterCallback(final Context context) {
        com.igexin.b.a.a().a("GTALCallback").execute(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (PushManager.this.callback == null || Build.VERSION.SDK_INT < 14) {
                        return;
                    }
                    Application application = PushManager.this.getMainApplication(context);
                    if (application == null) {
                        return;
                    }
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)PushManager.this.callback);
                    PushManager.this.callback = null;
                    System.currentTimeMillis();
                    com.igexin.c.a.c.a.a("PushManager | unRegisterCallback time= " + System.currentTimeMillis(), new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    com.igexin.c.a.c.a.a(throwable);
                    return;
                }
            }
        });
    }

    private boolean checkGTCVersion() {
        if (com.igexin.push.g.d.b("3.2.5.0")) {
            c.a().a("[PushManager] GTC Version Need >= 3.2.5.0");
            return false;
        }
        return true;
    }

    private Application getMainApplication(Context context) {
        if (context == null || !this.isMainProcess(context)) {
            return null;
        }
        if (context instanceof Application) {
            return (Application)context;
        }
        return (Application)context.getApplicationContext();
    }

    private boolean isMainProcess(Context context) {
        try {
            GtcProvider.setContext((Context)context);
            return CommonUtil.isMainProcess();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void checkContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("NULL context");
        }
    }

    private int getAssistAction(int n2, String string) {
        if (TextUtils.isEmpty((CharSequence)string) || !string.contains("_") || n2 != 60001 && n2 != 60002) {
            return n2;
        }
        if (string.startsWith("HW_")) {
            return n2 + 18;
        }
        if (string.startsWith("XM_")) {
            return n2 + 48;
        }
        if (string.startsWith("OP_")) {
            return n2 + 28;
        }
        if (string.startsWith("VV_")) {
            return n2 + 38;
        }
        if (string.startsWith("MZ_")) {
            return n2 + 58;
        }
        if (string.startsWith("ST_")) {
            return n2 + 78;
        }
        if (string.startsWith("FCM_")) {
            return n2 + 98;
        }
        if (string.startsWith("HO_")) {
            return n2 + 118;
        }
        return n2;
    }

    public void checkManifest(Context context) throws GetuiPushException {
        if (this.isMainProcess(context)) {
            com.igexin.push.g.c.c(context);
        }
    }

    public void setDebugLogger(Context object, IUserLoggerInterface iUserLoggerInterface) {
        if (object == null || iUserLoggerInterface == null) {
            throw new IllegalArgumentException("context or loggerInterface can not be null");
        }
        try {
            GtcProvider.setContext((Context)object);
            if (!com.igexin.push.g.c.a((Context)object)) {
                iUserLoggerInterface.log("only run in debug mode");
                return;
            }
            if (!this.isMainProcess((Context)object)) {
                iUserLoggerInterface.log("Must be called in main process!");
                return;
            }
            try {
                this.checkManifest((Context)object);
            }
            catch (GetuiPushException getuiPushException) {
                iUserLoggerInterface.log(getuiPushException.toString());
            }
            IUserLoggerInterface iUserLoggerInterface2 = iUserLoggerInterface;
            iUserLoggerInterface = object;
            object = c.a();
            if (iUserLoggerInterface2 == null) {
                e.a("LogController", "user logger register parameter can not be null!");
                return;
            }
            iUserLoggerInterface = iUserLoggerInterface.getApplicationContext();
            ((c)((Object)object)).a((Context)iUserLoggerInterface);
            ((c)((Object)object)).b.a(iUserLoggerInterface2);
            ((c)((Object)object)).b.a();
            ((c)((Object)object)).a("[LogController] Sdk version = " + PushManager.getInstance().getVersion((Context)iUserLoggerInterface));
            return;
        }
        catch (Throwable throwable) {
            com.igexin.c.a.c.a.a(throwable);
            return;
        }
    }

    @Deprecated
    public <T extends GTIntentService> void registerPushIntentService(Context context, Class<T> serializable) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            com.igexin.c.a.c.a.a("PushManager|call registerPushIntentService", new Object[0]);
            if (serializable != null) {
                try {
                    Class.forName(((Class)serializable).getName());
                }
                catch (Exception exception) {
                    com.igexin.c.a.c.a.a("PushManager|registerPushIntentService|" + exception.toString(), new Object[0]);
                    return;
                }
                if (!com.igexin.push.g.c.a(new Intent(context, (Class)serializable), context)) {
                    e.a(TAG, "call - > registerPushIntentService, parameter [userIntentService] is set, but didn't find class \"" + ((Class)serializable).getName() + "\", please check your AndroidManifest");
                    return;
                }
                this.uIntentService = ((Class)serializable).getName();
            } else {
                this.uIntentService = "";
            }
            if (this.uPushService != null) {
                com.igexin.c.a.c.a.b(TAG, "start service to save intent service");
                serializable = new Intent(context.getApplicationContext(), this.uPushService);
                serializable.putExtra("uis", this.uIntentService);
                this.startService(context, (Intent)serializable);
            }
            return;
        }
        catch (Throwable throwable) {
            serializable = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] registerPushIntentService  error = " + ((Throwable)serializable).toString());
            return;
        }
    }

    public boolean areNotificationsEnabled(Context context) {
        return com.igexin.push.g.c.b(context);
    }

    public void openNotification(Context context) {
        try {
            Intent intent = new Intent();
            if (Build.VERSION.SDK_INT >= 26) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", context.getApplicationInfo().uid);
                intent.setFlags(0x10000000);
            } else if (Build.VERSION.SDK_INT >= 21) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", context.getPackageName());
                intent.putExtra("app_uid", context.getApplicationInfo().uid);
                intent.setFlags(0x10000000);
            } else {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                intent.setData(uri);
                intent.setFlags(0x10000000);
            }
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Deprecated
    public boolean setOPPOBadgeNum(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("[PushManager] call - > setHwBadgeNum");
            Bundle bundle = new Bundle();
            bundle.putString("action", "setOppoBadgeNum");
            bundle.putInt("badgeNum", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setOPPOBadgeNum  error = " + throwable2.toString());
            return false;
        }
    }

    @Deprecated
    public boolean setVivoAppBadgeNum(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("[PushManager] call - > setHwBadgeNum");
            Bundle bundle = new Bundle();
            bundle.putString("action", "setVivoBadgeNum");
            bundle.putInt("badgeNum", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setOPPOBadgeNum  error = " + throwable2.toString());
            return false;
        }
    }

    @Deprecated
    public boolean setHwBadgeNum(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("[PushManager] call - > setHwBadgeNum");
            Bundle bundle = new Bundle();
            bundle.putString("action", "setHwBadgeNum");
            bundle.putInt("badgeNum", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setHwBadgeNum  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setBadgeNum(Context context, int n2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            c.a().a("[PushManager] call - > setBadgeNum");
            Bundle bundle = new Bundle();
            bundle.putString("action", "setBadgeNum");
            bundle.putInt("badgeNum", n2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setBadgeNum  error = " + throwable2.toString());
            return false;
        }
    }

    @Deprecated
    public boolean setGuardOptions(Context context, boolean bl, boolean bl2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            Bundle bundle = new Bundle();
            bundle.putString("action", "setGuardOptions");
            bundle.putBoolean("guardMe", bl);
            bundle.putBoolean("guardOthers", bl2);
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setGuardOptions  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setNotificationIcon(Context context, String string, String string2) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            Bundle bundle = new Bundle();
            bundle.putString("action", "setNotificationIcon");
            bundle.putString("smallIcon", string);
            bundle.putString("largeIcon", string2);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setNotificationIcon  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean queryPushOnLine(Context context) {
        try {
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            Bundle bundle = new Bundle();
            bundle.putString("action", "queryPushOnLine");
            Intent intent = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return this.startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] queryPushOnLine  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setDeviceToken(Context context, String string) {
        try {
            context = context.getApplicationContext();
            if (TextUtils.isEmpty((CharSequence)string)) {
                c.a().a("[PushManager] setDeviceToken error = token is empty");
                return false;
            }
            if (string.equalsIgnoreCase("InvalidAppKey")) {
                c.a().a("[PushManager] setDeviceToken error = token is InvalidAppKey");
                return false;
            }
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            Bundle bundle = new Bundle();
            bundle.putString("action", "setDeviceToken");
            bundle.putString("token", string);
            string = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            string.putExtra("action", "com.igexin.sdk.action.pushmanager");
            string.putExtra("bundle", bundle);
            return this.startService(context, (Intent)string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setDeviceToken  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean preInit(Context context) {
        try {
            Class clazz;
            context = context.getApplicationContext();
            if (TextUtils.isEmpty((CharSequence)this.uIntentService) && (clazz = (Class)com.igexin.push.g.d.a((Context)context, GTIntentService.class).second) != null) {
                this.uIntentService = clazz.getName();
            }
            if (this.uPushService == null) {
                this.uPushService = (Class)com.igexin.push.g.d.a((Context)context, PushService.class).second;
            }
            return true;
        }
        catch (Throwable throwable) {
            com.igexin.c.a.c.a.a(throwable);
            return false;
        }
    }

    public boolean setIndividuationPush(Context context, boolean bl) {
        try {
            context = context.getApplicationContext();
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            q.a(context, q.k, bl);
            boolean bl2 = (Boolean)q.b(context, "lkm", Boolean.TRUE);
            boolean bl3 = (Boolean)q.b(context, "emgph", Boolean.TRUE);
            bl = bl || bl2 || bl3;
            DimManager.getInstance().setSetting(context, f.b.e, Caller.PUSH.name(), String.valueOf(bl));
            c.a().a("[PushManager] setIndividuationPush success");
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setIndividuationPush  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setLinkMerge(Context context, boolean bl) {
        try {
            context = context.getApplicationContext();
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            q.a(context, "lkm", bl);
            boolean bl2 = (Boolean)q.b(context, q.k, Boolean.TRUE);
            boolean bl3 = (Boolean)q.b(context, "emgph", Boolean.TRUE);
            bl2 = bl2 || bl || bl3;
            DimManager.getInstance().setSetting(context, f.b.e, Caller.PUSH.name(), String.valueOf(bl2));
            Bundle bundle = new Bundle();
            bundle.putString("action", "setLinkMerge");
            bundle.putBoolean("enable", bl);
            Intent intent = new Intent(context.getApplicationContext(), PushManager.getInstance().getUserPushService(context));
            intent.putExtra("action", "com.igexin.sdk.action.pushmanager");
            intent.putExtra("bundle", bundle);
            return PushManager.getInstance().startService(context, intent);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setLinkMerge  error = " + throwable2.toString());
            return false;
        }
    }

    public boolean setScenePush(Context context, boolean bl) {
        try {
            context = context.getApplicationContext();
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            q.a(context, "secnph", bl);
            boolean bl2 = (Boolean)q.b(context, "emgph", Boolean.TRUE);
            bl = bl || bl2;
            DimManager.getInstance().setSetting(context, f.b.i, Caller.PUSH.name(), String.valueOf(bl));
            DimManager.getInstance().setSetting(context, f.b.g, Caller.PUSH.name(), String.valueOf(bl));
            DimManager.getInstance().setSetting(context, f.b.A, Caller.PUSH.name(), String.valueOf(bl));
            c.a().a("[PushManager] setScenePush success");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setScenePush  error = " + throwable2.toString());
            return false;
        }
        return true;
    }

    public boolean setEmergencyPush(Context context, boolean bl) {
        try {
            context = context.getApplicationContext();
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            q.a(context, "emgph", bl);
            boolean bl2 = (Boolean)q.b(context, "secnph", Boolean.TRUE) != false || bl;
            DimManager.getInstance().setSetting(context, f.b.A, Caller.PUSH.name(), String.valueOf(bl2));
            DimManager.getInstance().setSetting(context, f.b.i, Caller.PUSH.name(), String.valueOf(bl2));
            DimManager.getInstance().setSetting(context, f.b.g, Caller.PUSH.name(), String.valueOf(bl2));
            bl2 = (Boolean)q.b(context, q.k, Boolean.TRUE);
            bl = (Boolean)q.b(context, "lkm", Boolean.TRUE) != false || bl || bl2;
            DimManager.getInstance().setSetting(context, f.b.e, Caller.PUSH.name(), String.valueOf(bl));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setEmergencyPush  error = " + throwable2.toString());
            return false;
        }
        c.a().a("[PushManager] setEmergencyPush  success");
        return true;
    }

    public boolean setAppListInterval(Context context, long l2) {
        try {
            long l3 = l2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.f, Caller.PUSH.name(), String.valueOf(l3))) {
                c.a().a("[PushManager] setAppListInterval  error = \u5fc5\u987b\u57286-24\u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setAppListInterval success");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] setAppListInterval  error = " + throwable2.toString());
            return false;
        }
        return true;
    }

    public boolean setLocationInterval(Context context, long l2) {
        try {
            boolean bl = DimManager.getInstance().setSetting(context, f.b.h, Caller.PUSH.name(), String.valueOf(l2 * 1000L));
            boolean bl2 = DimManager.getInstance().setSetting(context, f.b.j, Caller.PUSH.name(), String.valueOf(l2 * 1000L));
            if (!bl || !bl2) {
                c.a().a("[PushManager] setLocationInterval  error = \u5fc5\u987b\u5728 5-1800 \u79d2\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setLocationInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setLocationInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setImsiEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.m, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setImsiEnable  error");
                return false;
            }
            c.a().a("[PushManager] setImsiEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setImsiEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setImsiInterval(Context context, int n2) {
        try {
            long l2 = (long)n2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.n, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setImsiInterval  error = \u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setImsiInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setImsiInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setImeiEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.k, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setImeiEnable  error");
                return false;
            }
            c.a().a("[PushManager] setImeiEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setImeiEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setImeiInterval(Context context, int n2) {
        try {
            long l2 = (long)n2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.l, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setImeiInterval  error = \u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setImeiInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setImeiInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setMacEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.o, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setMacEnable  error");
                return false;
            }
            c.a().a("[PushManager] setMacEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setMacEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setMacInterval(Context context, int n2) {
        try {
            long l2 = (long)n2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.p, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setMacInterval  error = \u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setMacInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setMacInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setIccIdEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.q, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setIccIdEnable  error");
                return false;
            }
            c.a().a("[PushManager] setIccIdEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setIccIdEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setIccIdInterval(Context context, int n2) {
        try {
            long l2 = (long)n2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.r, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setIccIdInterval  error = \u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setIccIdInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setIccIdInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setSerialNumberEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.s, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setSerialNumberEnable  error");
                return false;
            }
            c.a().a("[PushManager] setSerialNumberEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setSerialNumberEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setSerialNumberInterval(Context context, int n2) {
        try {
            long l2 = (long)n2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.t, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setSerialNumberInterval  error = \u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setSerialNumberInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setSerialNumberInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setAdvertisingIdEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.u, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setAdvertisingIdEnable  error");
                return false;
            }
            c.a().a("[PushManager] setAdvertisingIdEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setAdvertisingIdEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setAdvertisingIdInterval(Context context, long l2) {
        try {
            long l3 = l2 * 60L * 60L * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.v, Caller.PUSH.name(), String.valueOf(l3))) {
                c.a().a("[PushManager] setAdvertisingIdInterval  error =\u5fc5\u987b\u5728 24-24*7 \u5c0f\u65f6\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setAdvertisingIdInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setAdvertisingIdInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setCellInfoEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.w, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setCellInfoEnable  error");
                return false;
            }
            c.a().a("[PushManager] setCellInfoEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setCellInfoEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setCellInfoInterval(Context context, int n2) {
        try {
            long l2 = n2 * 1000;
            if (!DimManager.getInstance().setSetting(context, f.b.x, Caller.PUSH.name(), String.valueOf(l2))) {
                c.a().a("[PushManager] setCellInfoInterval  error = \u5fc5\u987b\u5728 5-1800 \u79d2\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setCellInfoInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setCellInfoInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setIpEnable(Context context, boolean bl) {
        try {
            if (!DimManager.getInstance().setSetting(context, f.b.y, Caller.PUSH.name(), String.valueOf(bl))) {
                c.a().a("[PushManager] setIpEnable  error");
                return false;
            }
            c.a().a("[PushManager] setIpEnable success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setIpEnable fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setIpInterval(Context context, long l2) {
        try {
            long l3 = l2 * 1000L;
            if (!DimManager.getInstance().setSetting(context, f.b.z, Caller.PUSH.name(), String.valueOf(l3))) {
                c.a().a("[PushManager] setIpInterval  error = \u5fc5\u987b\u5728 5-1800  \u79d2\u4e4b\u95f4");
                return false;
            }
            c.a().a("[PushManager] setIpInterval success");
        }
        catch (Throwable throwable) {
            c.a().a("[PushManager] setIpInterval fail " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public boolean setFenceLabels(Context context, List<Label> object) {
        try {
            Object object2;
            PushManager.checkContext(context);
            GtcProvider.setContext((Context)context);
            if (object == null) {
                c.a().a("[PushManager] call -> setFenceLabels failed, parameter labels is null");
                com.igexin.c.a.c.a.a("PushManager|labels is null", new Object[0]);
                this.sendFenceLabelResult(context, "40001");
                return false;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastSetFenceLabelsTime < 1000L) {
                c.a().a("[PushManager] call - > set fenceLabels failed, it be called too frequently");
                this.sendFenceLabelResult(context, "40002");
                return false;
            }
            if (object.size() == 0 || object.size() > 100) {
                c.a().a("[PushManager] call -> set fenceLabels failed, labels  is  illegal");
                this.sendFenceLabelResult(context, "40011");
                return false;
            }
            JSONArray jSONArray = object.iterator();
            while (jSONArray.hasNext()) {
                object2 = jSONArray.next();
                if (!(object2 == null || TextUtils.isEmpty((CharSequence)((Label)object2).getTagName()) || ((Label)object2).getTagName().length() > 32 || ((Label)object2).getTagName().matches(".*[\n\r].*") || TextUtils.isEmpty((CharSequence)((Label)object2).getTagId()) || ((Label)object2).getTagId().length() > 32 || ((Label)object2).getTagId().startsWith("g_") || !((Label)object2).getTagId().matches("^[a-zA-Z0-9_-]+$") || !TextUtils.isEmpty((CharSequence)((Label)object2).getTagVersion()) && (((Label)object2).getTagVersion().matches(".*[\n\r].*") || ((Label)object2).getTagVersion().length() > 32) || !TextUtils.isEmpty((CharSequence)((Label)object2).getExtraData()) && ((Label)object2).getExtraData().matches(".*[\n\r].*") || ((Label)object2).getEndTime() <= 0L)) continue;
                c.a().a("[PushManager] call -> set fenceLabels failed, labels  is  illegal");
                this.sendFenceLabelResult(context, "40011");
                return false;
            }
            jSONArray = new JSONArray();
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = (Label)object2.next();
                jSONArray.put((Object)((Label)object).getJsonObject());
            }
            this.lastSetFenceLabelsTime = l2;
            object2 = new Bundle();
            object2.putString("action", "setFenceLabels");
            object2.putString("labels", jSONArray.toString());
            object = new Intent(context.getApplicationContext(), this.getUserPushService(context));
            object.putExtra("action", "com.igexin.sdk.action.pushmanager");
            object.putExtra("bundle", (Bundle)object2);
            this.startService(context, (Intent)object);
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.igexin.c.a.c.a.a(throwable);
            c.a().a("[PushManager] set fenceLabels  error = " + throwable2.toString());
            return false;
        }
    }

    private void sendFenceLabelResult(Context context, String string) {
        this.sendResult(context, new SetFenceLabelMessage(string, 40009));
    }

    static final class a {
        private static final PushManager a = new PushManager();

        private a() {
        }
    }
}

