/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.sdk.router.boatman;

import com.igexin.sdk.router.boatman.BoatBean;
import com.igexin.sdk.router.boatman.Boater;
import com.igexin.sdk.router.boatman.IShips;
import com.igexin.sdk.router.boatman.receive.IBoatResult;
import com.igexin.sdk.router.boatman.receive.Site;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ShipsManagerImpl
implements IShips {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Site> subMaps = new ConcurrentHashMap<String, Site>();
    private final Map<String, List<BoatBean>> cacheMaps = new HashMap<String, List<BoatBean>>();

    @Override
    public final void register(Site site) {
        Iterator iterator = site.getTag();
        this.lock.lock();
        try {
            this.subMaps.put((String)((Object)iterator), site);
            iterator = this.cacheMaps.get(iterator);
            if (iterator != null && iterator.size() > 0) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    BoatBean boatBean = (BoatBean)iterator.next();
                    if (boatBean.getListener() != null) {
                        site.onArrived(boatBean.getBag(), boatBean.getListener());
                    }
                    iterator.remove();
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void unRegister(Site site) {
        this.lock.lock();
        try {
            this.subMaps.remove(site.getTag());
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean isRegistered(Site site) {
        return this.subMaps.containsKey(site.getTag());
    }

    final <B, V> void postSticky(Boater<B, V> boater, B b2, IBoatResult<V> iBoatResult) {
        boolean bl;
        String string = boater.getTag();
        this.lock.lock();
        try {
            bl = this.subMaps.containsKey(boater.getTag());
            if (!bl) {
                if (this.cacheMaps.get(string) == null) {
                    this.cacheMaps.put(string, new ArrayList());
                }
                this.cacheMaps.get(string).add(new BoatBean(b2, iBoatResult));
            }
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            this.postASync(boater, b2, iBoatResult);
        }
    }

    final boolean removeSticky(Boater object, Object object2) {
        object = ((Boater)object).getTag();
        boolean bl = false;
        this.lock.lock();
        try {
            object = this.cacheMaps.get(object);
            if (object == null) {
                return false;
            }
            object = object.iterator();
            while (object.hasNext()) {
                if (((BoatBean)object.next()).getBag() != object2) continue;
                bl = true;
                object.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    final <B, V> V postSync(Boater<B, V> object, B b2) {
        if ((object = this.subMaps.get(((Boater)object).getTag())) == null) {
            return null;
        }
        return ((Site)object).onArrived(b2);
    }

    final <B, V> void postASync(Boater<B, V> object, B b2, IBoatResult<V> iBoatResult) {
        if ((object = this.subMaps.get(((Boater)object).getTag())) == null) {
            return;
        }
        ((Site)object).onArrived(b2, iBoatResult);
    }
}

