/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.assist.control.meizu;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import android.util.Log;
import com.igexin.assist.control.AbstractPushManager;
import com.igexin.assist.control.meizu.Utils;
import com.meizu.cloud.pushsdk.PushManager;

public class FlymePushManager
implements AbstractPushManager {
    public static final String TAG = "Assist_MZ";
    public static final String PLUGIN_VERSION = "3.3.1";
    private String appId = "";
    private String appKey = "";

    public FlymePushManager(Context context) {
        try {
            String string2 = "5.0.5";
            try {
                string2 = PushManager.getSdkVersion();
            }
            catch (Exception exception) {}
            Log.d((String)TAG, (String)"meizu plugin version = 3.3.1, meizu sdk version = ".concat(String.valueOf(string2)));
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            this.appId = Utils.getAppIdByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                this.appId = (String)context.metaData.get("MEIZUPUSH_APPID");
                this.appId = this.appId.replace("MZ_", "");
            }
            this.appKey = Utils.getAppKeyByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appKey)) {
                this.appKey = (String)context.metaData.get("MEIZUPUSH_APPKEY");
                this.appKey = this.appKey.replace("MZ_", "");
            }
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void register(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey)) {
                Log.d((String)TAG, (String)"Register meizupush appId not find");
                return;
            }
            Log.d((String)TAG, (String)("Register meizupush, pkg = " + context.getPackageName()));
            PushManager.register(context, this.appId, this.appKey);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void unregister(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey)) {
                Log.d((String)TAG, (String)"|Unregister meizupush appId not find");
                return;
            }
            Log.d((String)TAG, (String)"|Unregister meizupush");
            PushManager.unRegister(context, this.appId, this.appKey);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void turnOnPush(Context context) {
        if (context == null) {
            return;
        }
        String string2 = PushManager.getPushId(context);
        if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        PushManager.switchPush(context, this.appId, this.appKey, string2, true);
    }

    public void turnOffPush(Context context) {
        if (context == null) {
            return;
        }
        String string2 = PushManager.getPushId(context);
        if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        PushManager.switchPush(context, this.appId, this.appKey, string2, false);
    }

    public String getToken(Context context) {
        if (context == null) {
            return null;
        }
        return PushManager.getPushId(context);
    }

    public void setSilentTime(Context context, int n, int n2) {
    }

    public boolean isSupport() {
        return false;
    }

    public String getBrandCode() {
        return null;
    }

    public static boolean checkMZDevice(Context context) {
        try {
            return PushManager.isBrandMeizu();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isBrandMeizu() {
        try {
            return PushManager.isBrandMeizu();
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

