/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.response.handler;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushsdk.f.a;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.response.MessageListener;

public abstract class MessageHandler<T> {
    private final String tag;

    public MessageHandler() {
        MessageHandler messageHandler = this;
        messageHandler.tag = messageHandler.getClass().getSimpleName();
    }

    public boolean sendMessage(Context context, Intent intent, MessageListener messageListener) {
        if (!"com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction())) {
            return false;
        }
        if (!this.getMethod().equals(intent.getStringExtra("method"))) {
            return false;
        }
        T t = this.getMessage(context, intent);
        if (!this.securityCheck(context, t, intent)) {
            a.b(this.tag, "invalid push message");
            return false;
        }
        MessageHandler messageHandler = this;
        a.c(this.tag, "current Handler message ".concat(String.valueOf(t)));
        messageHandler.onMessage(context, intent, t, messageListener);
        a.c(messageHandler.tag, "send message end ");
        return true;
    }

    public abstract String getMethod();

    protected abstract T getMessage(Context var1, Intent var2);

    protected abstract boolean securityCheck(Context var1, T var2, Intent var3);

    protected String getMessageValue(Intent intent) {
        block3: {
            MessageV3 messageV3 = (MessageV3)intent.getParcelableExtra("pushMessage");
            if (messageV3 == null) break block3;
            try {
                return MessageV3.messageV3ToString(messageV3);
            }
            catch (Exception exception) {
                a.b(this.tag, "getMessageValue error, ".concat(String.valueOf(exception)));
            }
        }
        return intent.getStringExtra("messageValue");
    }

    public abstract void onMessage(Context var1, Intent var2, T var3, MessageListener var4);
}

