/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushServiceReceiver;
import com.xiaomi.push.ci;
import com.xiaomi.push.cx;
import java.io.Serializable;
import java.util.List;

public class PushMessageHelper {
    public static final String MESSAGE_TYPE = "message_type";
    public static final int MESSAGE_RAW = 1;
    public static final int MESSAGE_SENDMESSAGE = 2;
    public static final int MESSAGE_COMMAND = 3;
    public static final int MESSAGE_QUIT = 4;
    public static final int MESSAGE_ERROR = 5;
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ERROR_TYPE = "error_type";
    public static final String ERROR_TYPE_NEED_PERMISSION = "error_lack_of_permission";
    public static final String KEY_MESSAGE = "key_message";
    public static final String KEY_COMMAND = "key_command";
    public static final int PUSH_MODE_CALLBACK = 1;
    public static final int PUSH_MODE_BROADCAST = 2;
    private static int pushMode = 0;

    private static boolean isIntentAvailable(Context object, Intent intent) {
        object = object.getPackageManager();
        try {
            object = object.queryBroadcastReceivers(intent, 32);
            return object != null && !object.isEmpty();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getPushMode(Context context) {
        if (pushMode == 0) {
            if (PushMessageHelper.isUseCallbackPushMode(context)) {
                PushMessageHelper.setPushMode(1);
            } else {
                PushMessageHelper.setPushMode(2);
            }
        }
        return pushMode;
    }

    private static void setPushMode(int n2) {
        pushMode = n2;
    }

    public static boolean isUseCallbackPushMode(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setClassName(context.getPackageName(), "com.xiaomi.mipush.sdk.PushServiceReceiver");
        return PushMessageHelper.isIntentAvailable(context, intent);
    }

    public static void sendCommandMessageBroadcast(Context context, MiPushCommandMessage miPushCommandMessage) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 3);
        intent.putExtra(KEY_COMMAND, (Serializable)miPushCommandMessage);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static void sendQuitMessageBroadcast(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 4);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static MiPushCommandMessage generateCommandMessage(String string, List<String> list, long l2, String string2, String string3) {
        MiPushCommandMessage miPushCommandMessage = new MiPushCommandMessage();
        miPushCommandMessage.setCommand(string);
        miPushCommandMessage.setCommandArguments(list);
        miPushCommandMessage.setResultCode(l2);
        miPushCommandMessage.setReason(string2);
        miPushCommandMessage.setCategory(string3);
        return miPushCommandMessage;
    }

    public static MiPushMessage generateMessage(cx cx2, ci ci2, boolean bl2) {
        MiPushMessage miPushMessage = new MiPushMessage();
        miPushMessage.setMessageId(cx2.c);
        if (!TextUtils.isEmpty((CharSequence)cx2.g)) {
            miPushMessage.setMessageType(1);
            miPushMessage.setAlias(cx2.g);
        } else if (!TextUtils.isEmpty((CharSequence)cx2.f)) {
            miPushMessage.setMessageType(2);
            miPushMessage.setTopic(cx2.f);
        } else if (!TextUtils.isEmpty((CharSequence)cx2.l)) {
            miPushMessage.setMessageType(3);
            miPushMessage.setUserAccount(cx2.l);
        } else {
            miPushMessage.setMessageType(0);
        }
        miPushMessage.setCategory(cx2.k);
        if (cx2.h != null) {
            miPushMessage.setContent(cx2.h.d);
        }
        if (ci2 != null) {
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getMessageId())) {
                miPushMessage.setMessageId(ci2.a);
            }
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getTopic())) {
                miPushMessage.setTopic(ci2.c);
            }
            miPushMessage.setDescription(ci2.e);
            miPushMessage.setTitle(ci2.d);
            miPushMessage.setNotifyType(ci2.f);
            miPushMessage.setNotifyId(ci2.i);
            miPushMessage.setPassThrough(ci2.h);
            miPushMessage.setExtra(ci2.j);
        }
        miPushMessage.setNotified(bl2);
        return miPushMessage;
    }

    public static ci generateMessage(MiPushMessage miPushMessage) {
        ci ci2 = new ci();
        new ci().a = miPushMessage.getMessageId();
        ci2.c = miPushMessage.getTopic();
        ci2.e = miPushMessage.getDescription();
        ci2.d = miPushMessage.getTitle();
        ci2.c(miPushMessage.getNotifyId());
        ci2.a(miPushMessage.getNotifyType());
        ci2.b(miPushMessage.getPassThrough());
        ci2.j = miPushMessage.getExtra();
        return ci2;
    }
}

