/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.assist.control.xiaomi;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.igexin.assist.control.AbstractPushManager;
import com.igexin.assist.control.xiaomi.SpUtils;
import com.igexin.assist.control.xiaomi.Utils;
import com.igexin.assist.control.xiaomi.XmSystemUtils;
import com.xiaomi.channel.commonutils.android.a;
import com.xiaomi.mipush.sdk.MiPushClient;

public class ManufacturePushManager
implements AbstractPushManager {
    public static final String TAG = "Assist_XM";
    public static final String PLUGIN_VERSION = "3.5.0";
    public static final String XIAOMI_VERSION = "5_1_1-G";
    private static final String PACKAGE_XIAOMI = "com.xiaomi.xmsf";
    private String appId = "";
    private String appKey = "";
    private Context context;

    public ManufacturePushManager(Context context) {
        try {
            this.context = context;
            Log.d((String)TAG, (String)"xiaomi plugin version = 3.5.0, xiaomi sdk version = 5_1_1-G");
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            this.appId = Utils.getAppIdByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                this.appId = (String)context.metaData.get("MIPUSH_APPID");
                this.appId = this.appId.replace("XM_", "");
            }
            this.appKey = Utils.getAppKeyByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appKey)) {
                this.appKey = (String)context.metaData.get("MIPUSH_APPKEY");
                this.appKey = this.appKey.replace("XM_", "");
            }
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void register(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey) || context == null) {
                Log.d((String)TAG, (String)"Register mipush appId or appKey is empty, or context null.");
                return;
            }
            Log.d((String)TAG, (String)("Register mipush, pkg = " + context.getPackageName()));
            if (this.isSupport()) {
                Log.d((String)TAG, (String)"mipush support");
                long l2 = (System.currentTimeMillis() - SystemClock.elapsedRealtime()) / 1000L;
                long l3 = (Long)SpUtils.getParam(context, "xiaomi_dt_sp", 0L);
                if (l3 > 0L && l3 != l2) {
                    try {
                        MiPushClient.unregisterPush(context);
                    }
                    catch (Throwable throwable) {}
                }
                MiPushClient.setRegion(a.a);
                MiPushClient.registerPush(context, this.appId, this.appKey);
                return;
            }
            Log.d((String)TAG, (String)"mipush not support.");
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void unregister(Context context) {
        try {
            Log.d((String)TAG, (String)"Unregister mipush");
            if (context == null) {
                return;
            }
            MiPushClient.unregisterPush(context);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void turnOnPush(Context context) {
        if (context == null) {
            return;
        }
        MiPushClient.resumePush(context, this.appId);
    }

    public void turnOffPush(Context context) {
        if (context == null) {
            return;
        }
        MiPushClient.pausePush(context, this.appId);
    }

    public String getToken(Context context) {
        if (context == null) {
            return null;
        }
        return MiPushClient.getRegId(context);
    }

    public void setSilentTime(Context context, int n2, int n3) {
        if (n3 == 0) {
            this.turnOnPush(context);
            return;
        }
        int n4 = (n2 + n3) % 24;
        Log.d((String)TAG, (String)("getui setSilentTime" + n2 + ":" + n3));
        Log.d((String)TAG, (String)("mipush setAcceptTime" + n4 + ":" + n2));
        MiPushClient.setAcceptTime(context, n4, 0, n2, 0, null);
    }

    public boolean isSupport() {
        try {
            if (XmSystemUtils.isBrandXiaoMi()) {
                PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(PACKAGE_XIAOMI, 0);
                return packageInfo != null && packageInfo.versionCode >= 105;
            }
            return false;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)("support error is : " + throwable.toString()));
            return false;
        }
    }

    public String getBrandCode() {
        return "3";
    }
}

