/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.assist.control.xiaomi;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.igexin.assist.control.AbstractPushManager;
import com.igexin.assist.control.xiaomi.Utils;
import com.xiaomi.mipush.sdk.MiPushClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MiuiPushManager
implements AbstractPushManager {
    public static final String TAG = "Assist_XM";
    public static final String PLUGIN_VERSION = "3.5.0";
    public static final String XIAOMI_VERSION = "5_1_1-G";
    private static final String PACKAGE_XIAOMI = "com.xiaomi.xmsf";
    private static final String KEY_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String KEY_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String phoneBrand = Build.BRAND;
    private String appId = "";
    private String appKey = "";

    public MiuiPushManager(Context context) {
        try {
            Log.d((String)TAG, (String)"xiaomi plugin version = 3.5.0, xiaomi sdk version = 5_1_1-G");
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            this.appId = Utils.getAppIdByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                this.appId = (String)context.metaData.get("MIPUSH_APPID");
                this.appId = this.appId.replace("XM_", "");
            }
            this.appKey = Utils.getAppKeyByBuildConfig((ApplicationInfo)context);
            if (TextUtils.isEmpty((CharSequence)this.appKey)) {
                this.appKey = (String)context.metaData.get("MIPUSH_APPKEY");
                this.appKey = this.appKey.replace("XM_", "");
            }
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void register(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey)) {
                Log.d((String)TAG, (String)"Register mipush appId or appKey is null or empty");
                return;
            }
            Log.d((String)TAG, (String)("Register mipush, pkg = " + context.getPackageName()));
            MiPushClient.registerPush(context, this.appId, this.appKey);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void unregister(Context context) {
        try {
            Log.d((String)TAG, (String)"Unregister mipush");
            if (context == null) {
                return;
            }
            MiPushClient.unregisterPush(context);
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)throwable.getMessage());
            return;
        }
    }

    public void turnOnPush(Context context) {
        if (context == null) {
            return;
        }
        MiPushClient.resumePush(context, this.appId);
    }

    public void turnOffPush(Context context) {
        if (context == null) {
            return;
        }
        MiPushClient.pausePush(context, this.appId);
    }

    public String getToken(Context context) {
        if (context == null) {
            return null;
        }
        return MiPushClient.getRegId(context);
    }

    public void setSilentTime(Context context, int n2, int n3) {
        if (n3 == 0) {
            this.turnOnPush(context);
            return;
        }
        int n4 = (n2 + n3) % 24;
        Log.d((String)TAG, (String)("getui setSilentTime" + n2 + ":" + n3));
        Log.d((String)TAG, (String)("mipush setAcceptTime" + n4 + ":" + n2));
        MiPushClient.setAcceptTime(context, n4, 0, n2, 0, null);
    }

    public boolean isSupport() {
        return false;
    }

    public String getBrandCode() {
        return null;
    }

    public static boolean checkXMDevice(Context context) {
        try {
            if (MiuiPushManager.isMIUI()) {
                return (context = context.getPackageManager().getPackageInfo(PACKAGE_XIAOMI, 0)) != null && context.versionCode >= 105;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isMIUI() {
        String string = MiuiPushManager.getProp(KEY_VERSION_MIUI);
        String string2 = MiuiPushManager.getProp(KEY_VERSION_CODE);
        return !TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProp(String object) {
        BufferedReader bufferedReader = null;
        try {
            object = Runtime.getRuntime().exec("getprop ".concat(String.valueOf(object)));
            bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()), 1024);
            object = bufferedReader.readLine();
        }
        catch (Exception exception) {
            if (bufferedReader == null) return null;
            try {
                bufferedReader.close();
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
        catch (Throwable throwable) {
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return object;
        }
    }
}

